<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetGeneratedParcels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGeneratedParcels $parameters
     * @return \StructType\GetGeneratedParcelsResponse|bool
     */
    public function GetGeneratedParcels(\StructType\GetGeneratedParcels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetGeneratedParcels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailablePickups
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAvailablePickups $parameters
     * @return \StructType\GetAvailablePickupsResponse|bool
     */
    public function GetAvailablePickups(\StructType\GetAvailablePickups $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailablePickups($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAvailablePickupsResponse|\StructType\GetGeneratedParcelsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
