<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RedisCacheInfo StructType
 * @subpackage Structs
 */
class RedisCacheInfo extends AbstractStructBase
{
    /**
     * The LastRefresh
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastRefresh;
    /**
     * The LastExecutionTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TimeSpan
     */
    public $LastExecutionTime;
    /**
     * The LastCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $LastCount;
    /**
     * The UpdatingServer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UpdatingServer;
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Result;
    /**
     * Constructor method for RedisCacheInfo
     * @uses RedisCacheInfo::setLastRefresh()
     * @uses RedisCacheInfo::setLastExecutionTime()
     * @uses RedisCacheInfo::setLastCount()
     * @uses RedisCacheInfo::setUpdatingServer()
     * @uses RedisCacheInfo::setResult()
     * @param string $lastRefresh
     * @param \StructType\TimeSpan $lastExecutionTime
     * @param int $lastCount
     * @param string $updatingServer
     * @param string $result
     */
    public function __construct($lastRefresh = null, \StructType\TimeSpan $lastExecutionTime = null, $lastCount = null, $updatingServer = null, $result = null)
    {
        $this
            ->setLastRefresh($lastRefresh)
            ->setLastExecutionTime($lastExecutionTime)
            ->setLastCount($lastCount)
            ->setUpdatingServer($updatingServer)
            ->setResult($result);
    }
    /**
     * Get LastRefresh value
     * @return string
     */
    public function getLastRefresh()
    {
        return $this->LastRefresh;
    }
    /**
     * Set LastRefresh value
     * @param string $lastRefresh
     * @return \StructType\RedisCacheInfo
     */
    public function setLastRefresh($lastRefresh = null)
    {
        // validation for constraint: string
        if (!is_null($lastRefresh) && !is_string($lastRefresh)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastRefresh, true), gettype($lastRefresh)), __LINE__);
        }
        $this->LastRefresh = $lastRefresh;
        return $this;
    }
    /**
     * Get LastExecutionTime value
     * @return \StructType\TimeSpan
     */
    public function getLastExecutionTime()
    {
        return $this->LastExecutionTime;
    }
    /**
     * Set LastExecutionTime value
     * @param \StructType\TimeSpan $lastExecutionTime
     * @return \StructType\RedisCacheInfo
     */
    public function setLastExecutionTime(\StructType\TimeSpan $lastExecutionTime = null)
    {
        $this->LastExecutionTime = $lastExecutionTime;
        return $this;
    }
    /**
     * Get LastCount value
     * @return int
     */
    public function getLastCount()
    {
        return $this->LastCount;
    }
    /**
     * Set LastCount value
     * @param int $lastCount
     * @return \StructType\RedisCacheInfo
     */
    public function setLastCount($lastCount = null)
    {
        // validation for constraint: int
        if (!is_null($lastCount) && !(is_int($lastCount) || ctype_digit($lastCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastCount, true), gettype($lastCount)), __LINE__);
        }
        $this->LastCount = $lastCount;
        return $this;
    }
    /**
     * Get UpdatingServer value
     * @return string|null
     */
    public function getUpdatingServer()
    {
        return $this->UpdatingServer;
    }
    /**
     * Set UpdatingServer value
     * @param string $updatingServer
     * @return \StructType\RedisCacheInfo
     */
    public function setUpdatingServer($updatingServer = null)
    {
        // validation for constraint: string
        if (!is_null($updatingServer) && !is_string($updatingServer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updatingServer, true), gettype($updatingServer)), __LINE__);
        }
        $this->UpdatingServer = $updatingServer;
        return $this;
    }
    /**
     * Get Result value
     * @return string|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param string $result
     * @return \StructType\RedisCacheInfo
     */
    public function setResult($result = null)
    {
        // validation for constraint: string
        if (!is_null($result) && !is_string($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
}
