<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PointPwRSuggestion StructType
 * @subpackage Structs
 */
class PointPwRSuggestion extends AbstractStructBase
{
    /**
     * The PSD
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PSD;
    /**
     * The Distance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Distance;
    /**
     * The DestinationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DestinationCode;
    /**
     * Constructor method for PointPwRSuggestion
     * @uses PointPwRSuggestion::setPSD()
     * @uses PointPwRSuggestion::setDistance()
     * @uses PointPwRSuggestion::setDestinationCode()
     * @param int $pSD
     * @param float $distance
     * @param string $destinationCode
     */
    public function __construct($pSD = null, $distance = null, $destinationCode = null)
    {
        $this
            ->setPSD($pSD)
            ->setDistance($distance)
            ->setDestinationCode($destinationCode);
    }
    /**
     * Get PSD value
     * @return int
     */
    public function getPSD()
    {
        return $this->PSD;
    }
    /**
     * Set PSD value
     * @param int $pSD
     * @return \StructType\PointPwRSuggestion
     */
    public function setPSD($pSD = null)
    {
        // validation for constraint: int
        if (!is_null($pSD) && !(is_int($pSD) || ctype_digit($pSD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pSD, true), gettype($pSD)), __LINE__);
        }
        $this->PSD = $pSD;
        return $this;
    }
    /**
     * Get Distance value
     * @return float
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param float $distance
     * @return \StructType\PointPwRSuggestion
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: float
        if (!is_null($distance) && !(is_float($distance) || is_numeric($distance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distance, true), gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get DestinationCode value
     * @return string|null
     */
    public function getDestinationCode()
    {
        return $this->DestinationCode;
    }
    /**
     * Set DestinationCode value
     * @param string $destinationCode
     * @return \StructType\PointPwRSuggestion
     */
    public function setDestinationCode($destinationCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCode) && !is_string($destinationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationCode, true), gettype($destinationCode)), __LINE__);
        }
        $this->DestinationCode = $destinationCode;
        return $this;
    }
}
