<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PointPwR StructType
 * @subpackage Structs
 */
class PointPwR extends AbstractStructBase
{
    /**
     * The CashOnDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CashOnDelivery;
    /**
     * The PSD
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PSD;
    /**
     * The Filled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Filled;
    /**
     * The Available
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Available;
    /**
     * The DestinationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DestinationCode;
    /**
     * The StreetName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StreetName;
    /**
     * The BuilingNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BuilingNumber;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The District
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $District;
    /**
     * The Latitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Longitude;
    /**
     * The Province
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Province;
    /**
     * The OpeningHours
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OpeningHours;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Location;
    /**
     * The Aviable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aviable;
    /**
     * The PointType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PointType;
    /**
     * The Suggestions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPointPwRSuggestion
     */
    public $Suggestions;
    /**
     * The BuildingNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BuildingNumber;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * Constructor method for PointPwR
     * @uses PointPwR::setCashOnDelivery()
     * @uses PointPwR::setPSD()
     * @uses PointPwR::setFilled()
     * @uses PointPwR::setAvailable()
     * @uses PointPwR::setDestinationCode()
     * @uses PointPwR::setStreetName()
     * @uses PointPwR::setBuilingNumber()
     * @uses PointPwR::setCity()
     * @uses PointPwR::setDistrict()
     * @uses PointPwR::setLatitude()
     * @uses PointPwR::setLongitude()
     * @uses PointPwR::setProvince()
     * @uses PointPwR::setOpeningHours()
     * @uses PointPwR::setLocation()
     * @uses PointPwR::setAviable()
     * @uses PointPwR::setPointType()
     * @uses PointPwR::setSuggestions()
     * @uses PointPwR::setBuildingNumber()
     * @uses PointPwR::setZipCode()
     * @param bool $cashOnDelivery
     * @param int $pSD
     * @param bool $filled
     * @param bool $available
     * @param string $destinationCode
     * @param string $streetName
     * @param string $builingNumber
     * @param string $city
     * @param string $district
     * @param string $latitude
     * @param string $longitude
     * @param string $province
     * @param string $openingHours
     * @param string $location
     * @param string $aviable
     * @param string $pointType
     * @param \ArrayType\ArrayOfPointPwRSuggestion $suggestions
     * @param string $buildingNumber
     * @param string $zipCode
     */
    public function __construct($cashOnDelivery = null, $pSD = null, $filled = null, $available = null, $destinationCode = null, $streetName = null, $builingNumber = null, $city = null, $district = null, $latitude = null, $longitude = null, $province = null, $openingHours = null, $location = null, $aviable = null, $pointType = null, \ArrayType\ArrayOfPointPwRSuggestion $suggestions = null, $buildingNumber = null, $zipCode = null)
    {
        $this
            ->setCashOnDelivery($cashOnDelivery)
            ->setPSD($pSD)
            ->setFilled($filled)
            ->setAvailable($available)
            ->setDestinationCode($destinationCode)
            ->setStreetName($streetName)
            ->setBuilingNumber($builingNumber)
            ->setCity($city)
            ->setDistrict($district)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setProvince($province)
            ->setOpeningHours($openingHours)
            ->setLocation($location)
            ->setAviable($aviable)
            ->setPointType($pointType)
            ->setSuggestions($suggestions)
            ->setBuildingNumber($buildingNumber)
            ->setZipCode($zipCode);
    }
    /**
     * Get CashOnDelivery value
     * @return bool
     */
    public function getCashOnDelivery()
    {
        return $this->CashOnDelivery;
    }
    /**
     * Set CashOnDelivery value
     * @param bool $cashOnDelivery
     * @return \StructType\PointPwR
     */
    public function setCashOnDelivery($cashOnDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($cashOnDelivery) && !is_bool($cashOnDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cashOnDelivery, true), gettype($cashOnDelivery)), __LINE__);
        }
        $this->CashOnDelivery = $cashOnDelivery;
        return $this;
    }
    /**
     * Get PSD value
     * @return int
     */
    public function getPSD()
    {
        return $this->PSD;
    }
    /**
     * Set PSD value
     * @param int $pSD
     * @return \StructType\PointPwR
     */
    public function setPSD($pSD = null)
    {
        // validation for constraint: int
        if (!is_null($pSD) && !(is_int($pSD) || ctype_digit($pSD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pSD, true), gettype($pSD)), __LINE__);
        }
        $this->PSD = $pSD;
        return $this;
    }
    /**
     * Get Filled value
     * @return bool
     */
    public function getFilled()
    {
        return $this->Filled;
    }
    /**
     * Set Filled value
     * @param bool $filled
     * @return \StructType\PointPwR
     */
    public function setFilled($filled = null)
    {
        // validation for constraint: boolean
        if (!is_null($filled) && !is_bool($filled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($filled, true), gettype($filled)), __LINE__);
        }
        $this->Filled = $filled;
        return $this;
    }
    /**
     * Get Available value
     * @return bool
     */
    public function getAvailable()
    {
        return $this->Available;
    }
    /**
     * Set Available value
     * @param bool $available
     * @return \StructType\PointPwR
     */
    public function setAvailable($available = null)
    {
        // validation for constraint: boolean
        if (!is_null($available) && !is_bool($available)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($available, true), gettype($available)), __LINE__);
        }
        $this->Available = $available;
        return $this;
    }
    /**
     * Get DestinationCode value
     * @return string|null
     */
    public function getDestinationCode()
    {
        return $this->DestinationCode;
    }
    /**
     * Set DestinationCode value
     * @param string $destinationCode
     * @return \StructType\PointPwR
     */
    public function setDestinationCode($destinationCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCode) && !is_string($destinationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationCode, true), gettype($destinationCode)), __LINE__);
        }
        $this->DestinationCode = $destinationCode;
        return $this;
    }
    /**
     * Get StreetName value
     * @return string|null
     */
    public function getStreetName()
    {
        return $this->StreetName;
    }
    /**
     * Set StreetName value
     * @param string $streetName
     * @return \StructType\PointPwR
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetName, true), gettype($streetName)), __LINE__);
        }
        $this->StreetName = $streetName;
        return $this;
    }
    /**
     * Get BuilingNumber value
     * @return string|null
     */
    public function getBuilingNumber()
    {
        return $this->BuilingNumber;
    }
    /**
     * Set BuilingNumber value
     * @param string $builingNumber
     * @return \StructType\PointPwR
     */
    public function setBuilingNumber($builingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($builingNumber) && !is_string($builingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($builingNumber, true), gettype($builingNumber)), __LINE__);
        }
        $this->BuilingNumber = $builingNumber;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\PointPwR
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get District value
     * @return string|null
     */
    public function getDistrict()
    {
        return $this->District;
    }
    /**
     * Set District value
     * @param string $district
     * @return \StructType\PointPwR
     */
    public function setDistrict($district = null)
    {
        // validation for constraint: string
        if (!is_null($district) && !is_string($district)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($district, true), gettype($district)), __LINE__);
        }
        $this->District = $district;
        return $this;
    }
    /**
     * Get Latitude value
     * @return string|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param string $latitude
     * @return \StructType\PointPwR
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: string
        if (!is_null($latitude) && !is_string($latitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return string|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param string $longitude
     * @return \StructType\PointPwR
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: string
        if (!is_null($longitude) && !is_string($longitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Province value
     * @return string|null
     */
    public function getProvince()
    {
        return $this->Province;
    }
    /**
     * Set Province value
     * @param string $province
     * @return \StructType\PointPwR
     */
    public function setProvince($province = null)
    {
        // validation for constraint: string
        if (!is_null($province) && !is_string($province)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($province, true), gettype($province)), __LINE__);
        }
        $this->Province = $province;
        return $this;
    }
    /**
     * Get OpeningHours value
     * @return string|null
     */
    public function getOpeningHours()
    {
        return $this->OpeningHours;
    }
    /**
     * Set OpeningHours value
     * @param string $openingHours
     * @return \StructType\PointPwR
     */
    public function setOpeningHours($openingHours = null)
    {
        // validation for constraint: string
        if (!is_null($openingHours) && !is_string($openingHours)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openingHours, true), gettype($openingHours)), __LINE__);
        }
        $this->OpeningHours = $openingHours;
        return $this;
    }
    /**
     * Get Location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param string $location
     * @return \StructType\PointPwR
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        $this->Location = $location;
        return $this;
    }
    /**
     * Get Aviable value
     * @return string|null
     */
    public function getAviable()
    {
        return $this->Aviable;
    }
    /**
     * Set Aviable value
     * @param string $aviable
     * @return \StructType\PointPwR
     */
    public function setAviable($aviable = null)
    {
        // validation for constraint: string
        if (!is_null($aviable) && !is_string($aviable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aviable, true), gettype($aviable)), __LINE__);
        }
        $this->Aviable = $aviable;
        return $this;
    }
    /**
     * Get PointType value
     * @return string|null
     */
    public function getPointType()
    {
        return $this->PointType;
    }
    /**
     * Set PointType value
     * @param string $pointType
     * @return \StructType\PointPwR
     */
    public function setPointType($pointType = null)
    {
        // validation for constraint: string
        if (!is_null($pointType) && !is_string($pointType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pointType, true), gettype($pointType)), __LINE__);
        }
        $this->PointType = $pointType;
        return $this;
    }
    /**
     * Get Suggestions value
     * @return \ArrayType\ArrayOfPointPwRSuggestion|null
     */
    public function getSuggestions()
    {
        return $this->Suggestions;
    }
    /**
     * Set Suggestions value
     * @param \ArrayType\ArrayOfPointPwRSuggestion $suggestions
     * @return \StructType\PointPwR
     */
    public function setSuggestions(\ArrayType\ArrayOfPointPwRSuggestion $suggestions = null)
    {
        $this->Suggestions = $suggestions;
        return $this;
    }
    /**
     * Get BuildingNumber value
     * @return string|null
     */
    public function getBuildingNumber()
    {
        return $this->BuildingNumber;
    }
    /**
     * Set BuildingNumber value
     * @param string $buildingNumber
     * @return \StructType\PointPwR
     */
    public function setBuildingNumber($buildingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($buildingNumber) && !is_string($buildingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buildingNumber, true), gettype($buildingNumber)), __LINE__);
        }
        $this->BuildingNumber = $buildingNumber;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \StructType\PointPwR
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
}
