<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelPrintDuplicate StructType
 * @subpackage Structs
 */
class LabelPrintDuplicate extends AbstractStructBase
{
    /**
     * The PartnerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerID;
    /**
     * The PartnerKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerKey;
    /**
     * The PackCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PackCode;
    /**
     * Constructor method for LabelPrintDuplicate
     * @uses LabelPrintDuplicate::setPartnerID()
     * @uses LabelPrintDuplicate::setPartnerKey()
     * @uses LabelPrintDuplicate::setPackCode()
     * @param string $partnerID
     * @param string $partnerKey
     * @param string $packCode
     */
    public function __construct($partnerID = null, $partnerKey = null, $packCode = null)
    {
        $this
            ->setPartnerID($partnerID)
            ->setPartnerKey($partnerKey)
            ->setPackCode($packCode);
    }
    /**
     * Get PartnerID value
     * @return string|null
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }
    /**
     * Set PartnerID value
     * @param string $partnerID
     * @return \StructType\LabelPrintDuplicate
     */
    public function setPartnerID($partnerID = null)
    {
        // validation for constraint: string
        if (!is_null($partnerID) && !is_string($partnerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerID, true), gettype($partnerID)), __LINE__);
        }
        $this->PartnerID = $partnerID;
        return $this;
    }
    /**
     * Get PartnerKey value
     * @return string|null
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }
    /**
     * Set PartnerKey value
     * @param string $partnerKey
     * @return \StructType\LabelPrintDuplicate
     */
    public function setPartnerKey($partnerKey = null)
    {
        // validation for constraint: string
        if (!is_null($partnerKey) && !is_string($partnerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerKey, true), gettype($partnerKey)), __LINE__);
        }
        $this->PartnerKey = $partnerKey;
        return $this;
    }
    /**
     * Get PackCode value
     * @return string|null
     */
    public function getPackCode()
    {
        return $this->PackCode;
    }
    /**
     * Set PackCode value
     * @param string $packCode
     * @return \StructType\LabelPrintDuplicate
     */
    public function setPackCode($packCode = null)
    {
        // validation for constraint: string
        if (!is_null($packCode) && !is_string($packCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packCode, true), gettype($packCode)), __LINE__);
        }
        $this->PackCode = $packCode;
        return $this;
    }
}
