<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiveShippingCodeStatus StructType
 * @subpackage Structs
 */
class GiveShippingCodeStatus extends AbstractStructBase
{
    /**
     * The PartnerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerID;
    /**
     * The PartnerKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerKey;
    /**
     * The Codes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Codes;
    /**
     * Constructor method for GiveShippingCodeStatus
     * @uses GiveShippingCodeStatus::setPartnerID()
     * @uses GiveShippingCodeStatus::setPartnerKey()
     * @uses GiveShippingCodeStatus::setCodes()
     * @param string $partnerID
     * @param string $partnerKey
     * @param \ArrayType\ArrayOfString $codes
     */
    public function __construct($partnerID = null, $partnerKey = null, \ArrayType\ArrayOfString $codes = null)
    {
        $this
            ->setPartnerID($partnerID)
            ->setPartnerKey($partnerKey)
            ->setCodes($codes);
    }
    /**
     * Get PartnerID value
     * @return string|null
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }
    /**
     * Set PartnerID value
     * @param string $partnerID
     * @return \StructType\GiveShippingCodeStatus
     */
    public function setPartnerID($partnerID = null)
    {
        // validation for constraint: string
        if (!is_null($partnerID) && !is_string($partnerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerID, true), gettype($partnerID)), __LINE__);
        }
        $this->PartnerID = $partnerID;
        return $this;
    }
    /**
     * Get PartnerKey value
     * @return string|null
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }
    /**
     * Set PartnerKey value
     * @param string $partnerKey
     * @return \StructType\GiveShippingCodeStatus
     */
    public function setPartnerKey($partnerKey = null)
    {
        // validation for constraint: string
        if (!is_null($partnerKey) && !is_string($partnerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerKey, true), gettype($partnerKey)), __LINE__);
        }
        $this->PartnerKey = $partnerKey;
        return $this;
    }
    /**
     * Get Codes value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getCodes()
    {
        return $this->Codes;
    }
    /**
     * Set Codes value
     * @param \ArrayType\ArrayOfString $codes
     * @return \StructType\GiveShippingCodeStatus
     */
    public function setCodes(\ArrayType\ArrayOfString $codes = null)
    {
        $this->Codes = $codes;
        return $this;
    }
}
