<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CallPickup StructType
 * @subpackage Structs
 */
class CallPickup extends AbstractStructBase
{
    /**
     * The readyDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $readyDate;
    /**
     * The pickupDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pickupDate;
    /**
     * The partnerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $partnerId;
    /**
     * The partnerKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $partnerKey;
    /**
     * The packList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $packList;
    /**
     * Constructor method for CallPickup
     * @uses CallPickup::setReadyDate()
     * @uses CallPickup::setPickupDate()
     * @uses CallPickup::setPartnerId()
     * @uses CallPickup::setPartnerKey()
     * @uses CallPickup::setPackList()
     * @param string $readyDate
     * @param string $pickupDate
     * @param string $partnerId
     * @param string $partnerKey
     * @param \ArrayType\ArrayOfString $packList
     */
    public function __construct($readyDate = null, $pickupDate = null, $partnerId = null, $partnerKey = null, \ArrayType\ArrayOfString $packList = null)
    {
        $this
            ->setReadyDate($readyDate)
            ->setPickupDate($pickupDate)
            ->setPartnerId($partnerId)
            ->setPartnerKey($partnerKey)
            ->setPackList($packList);
    }
    /**
     * Get readyDate value
     * @return string
     */
    public function getReadyDate()
    {
        return $this->readyDate;
    }
    /**
     * Set readyDate value
     * @param string $readyDate
     * @return \StructType\CallPickup
     */
    public function setReadyDate($readyDate = null)
    {
        // validation for constraint: string
        if (!is_null($readyDate) && !is_string($readyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($readyDate, true), gettype($readyDate)), __LINE__);
        }
        $this->readyDate = $readyDate;
        return $this;
    }
    /**
     * Get pickupDate value
     * @return string
     */
    public function getPickupDate()
    {
        return $this->pickupDate;
    }
    /**
     * Set pickupDate value
     * @param string $pickupDate
     * @return \StructType\CallPickup
     */
    public function setPickupDate($pickupDate = null)
    {
        // validation for constraint: string
        if (!is_null($pickupDate) && !is_string($pickupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupDate, true), gettype($pickupDate)), __LINE__);
        }
        $this->pickupDate = $pickupDate;
        return $this;
    }
    /**
     * Get partnerId value
     * @return string|null
     */
    public function getPartnerId()
    {
        return $this->partnerId;
    }
    /**
     * Set partnerId value
     * @param string $partnerId
     * @return \StructType\CallPickup
     */
    public function setPartnerId($partnerId = null)
    {
        // validation for constraint: string
        if (!is_null($partnerId) && !is_string($partnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerId, true), gettype($partnerId)), __LINE__);
        }
        $this->partnerId = $partnerId;
        return $this;
    }
    /**
     * Get partnerKey value
     * @return string|null
     */
    public function getPartnerKey()
    {
        return $this->partnerKey;
    }
    /**
     * Set partnerKey value
     * @param string $partnerKey
     * @return \StructType\CallPickup
     */
    public function setPartnerKey($partnerKey = null)
    {
        // validation for constraint: string
        if (!is_null($partnerKey) && !is_string($partnerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerKey, true), gettype($partnerKey)), __LINE__);
        }
        $this->partnerKey = $partnerKey;
        return $this;
    }
    /**
     * Get packList value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getPackList()
    {
        return $this->packList;
    }
    /**
     * Set packList value
     * @param \ArrayType\ArrayOfString $packList
     * @return \StructType\CallPickup
     */
    public function setPackList(\ArrayType\ArrayOfString $packList = null)
    {
        $this->packList = $packList;
        return $this;
    }
}
