<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApiStatus StructType
 * @subpackage Structs
 */
class ApiStatus extends AbstractStructBase
{
    /**
     * The IsPopulated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPopulated;
    /**
     * The HistoryCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HistoryCount;
    /**
     * The HistoryMinDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HistoryMinDate;
    /**
     * The HistoryMaxDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HistoryMaxDate;
    /**
     * The StatusCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StatusCount;
    /**
     * The PsdCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PsdCount;
    /**
     * The ClCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ClCount;
    /**
     * The CorelationCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CorelationCount;
    /**
     * The NearestPointCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NearestPointCount;
    /**
     * The PostalCodeZoneCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PostalCodeZoneCount;
    /**
     * The TypeCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TypeCount;
    /**
     * The PermissionCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PermissionCount;
    /**
     * The SuggestionsCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SuggestionsCount;
    /**
     * The DictionaryCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DictionaryCount;
    /**
     * The LastRefresh
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastRefresh;
    /**
     * The PartnerStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RedisCacheInfo
     */
    public $PartnerStatus;
    /**
     * The BuildNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BuildNumber;
    /**
     * The Feature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Feature;
    /**
     * Constructor method for ApiStatus
     * @uses ApiStatus::setIsPopulated()
     * @uses ApiStatus::setHistoryCount()
     * @uses ApiStatus::setHistoryMinDate()
     * @uses ApiStatus::setHistoryMaxDate()
     * @uses ApiStatus::setStatusCount()
     * @uses ApiStatus::setPsdCount()
     * @uses ApiStatus::setClCount()
     * @uses ApiStatus::setCorelationCount()
     * @uses ApiStatus::setNearestPointCount()
     * @uses ApiStatus::setPostalCodeZoneCount()
     * @uses ApiStatus::setTypeCount()
     * @uses ApiStatus::setPermissionCount()
     * @uses ApiStatus::setSuggestionsCount()
     * @uses ApiStatus::setDictionaryCount()
     * @uses ApiStatus::setLastRefresh()
     * @uses ApiStatus::setPartnerStatus()
     * @uses ApiStatus::setBuildNumber()
     * @uses ApiStatus::setFeature()
     * @param bool $isPopulated
     * @param int $historyCount
     * @param string $historyMinDate
     * @param string $historyMaxDate
     * @param int $statusCount
     * @param int $psdCount
     * @param int $clCount
     * @param int $corelationCount
     * @param int $nearestPointCount
     * @param int $postalCodeZoneCount
     * @param int $typeCount
     * @param int $permissionCount
     * @param int $suggestionsCount
     * @param int $dictionaryCount
     * @param string $lastRefresh
     * @param \StructType\RedisCacheInfo $partnerStatus
     * @param string $buildNumber
     * @param string $feature
     */
    public function __construct($isPopulated = null, $historyCount = null, $historyMinDate = null, $historyMaxDate = null, $statusCount = null, $psdCount = null, $clCount = null, $corelationCount = null, $nearestPointCount = null, $postalCodeZoneCount = null, $typeCount = null, $permissionCount = null, $suggestionsCount = null, $dictionaryCount = null, $lastRefresh = null, \StructType\RedisCacheInfo $partnerStatus = null, $buildNumber = null, $feature = null)
    {
        $this
            ->setIsPopulated($isPopulated)
            ->setHistoryCount($historyCount)
            ->setHistoryMinDate($historyMinDate)
            ->setHistoryMaxDate($historyMaxDate)
            ->setStatusCount($statusCount)
            ->setPsdCount($psdCount)
            ->setClCount($clCount)
            ->setCorelationCount($corelationCount)
            ->setNearestPointCount($nearestPointCount)
            ->setPostalCodeZoneCount($postalCodeZoneCount)
            ->setTypeCount($typeCount)
            ->setPermissionCount($permissionCount)
            ->setSuggestionsCount($suggestionsCount)
            ->setDictionaryCount($dictionaryCount)
            ->setLastRefresh($lastRefresh)
            ->setPartnerStatus($partnerStatus)
            ->setBuildNumber($buildNumber)
            ->setFeature($feature);
    }
    /**
     * Get IsPopulated value
     * @return bool
     */
    public function getIsPopulated()
    {
        return $this->IsPopulated;
    }
    /**
     * Set IsPopulated value
     * @param bool $isPopulated
     * @return \StructType\ApiStatus
     */
    public function setIsPopulated($isPopulated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPopulated) && !is_bool($isPopulated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPopulated, true), gettype($isPopulated)), __LINE__);
        }
        $this->IsPopulated = $isPopulated;
        return $this;
    }
    /**
     * Get HistoryCount value
     * @return int
     */
    public function getHistoryCount()
    {
        return $this->HistoryCount;
    }
    /**
     * Set HistoryCount value
     * @param int $historyCount
     * @return \StructType\ApiStatus
     */
    public function setHistoryCount($historyCount = null)
    {
        // validation for constraint: int
        if (!is_null($historyCount) && !(is_int($historyCount) || ctype_digit($historyCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($historyCount, true), gettype($historyCount)), __LINE__);
        }
        $this->HistoryCount = $historyCount;
        return $this;
    }
    /**
     * Get HistoryMinDate value
     * @return string
     */
    public function getHistoryMinDate()
    {
        return $this->HistoryMinDate;
    }
    /**
     * Set HistoryMinDate value
     * @param string $historyMinDate
     * @return \StructType\ApiStatus
     */
    public function setHistoryMinDate($historyMinDate = null)
    {
        // validation for constraint: string
        if (!is_null($historyMinDate) && !is_string($historyMinDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($historyMinDate, true), gettype($historyMinDate)), __LINE__);
        }
        $this->HistoryMinDate = $historyMinDate;
        return $this;
    }
    /**
     * Get HistoryMaxDate value
     * @return string
     */
    public function getHistoryMaxDate()
    {
        return $this->HistoryMaxDate;
    }
    /**
     * Set HistoryMaxDate value
     * @param string $historyMaxDate
     * @return \StructType\ApiStatus
     */
    public function setHistoryMaxDate($historyMaxDate = null)
    {
        // validation for constraint: string
        if (!is_null($historyMaxDate) && !is_string($historyMaxDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($historyMaxDate, true), gettype($historyMaxDate)), __LINE__);
        }
        $this->HistoryMaxDate = $historyMaxDate;
        return $this;
    }
    /**
     * Get StatusCount value
     * @return int
     */
    public function getStatusCount()
    {
        return $this->StatusCount;
    }
    /**
     * Set StatusCount value
     * @param int $statusCount
     * @return \StructType\ApiStatus
     */
    public function setStatusCount($statusCount = null)
    {
        // validation for constraint: int
        if (!is_null($statusCount) && !(is_int($statusCount) || ctype_digit($statusCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusCount, true), gettype($statusCount)), __LINE__);
        }
        $this->StatusCount = $statusCount;
        return $this;
    }
    /**
     * Get PsdCount value
     * @return int
     */
    public function getPsdCount()
    {
        return $this->PsdCount;
    }
    /**
     * Set PsdCount value
     * @param int $psdCount
     * @return \StructType\ApiStatus
     */
    public function setPsdCount($psdCount = null)
    {
        // validation for constraint: int
        if (!is_null($psdCount) && !(is_int($psdCount) || ctype_digit($psdCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($psdCount, true), gettype($psdCount)), __LINE__);
        }
        $this->PsdCount = $psdCount;
        return $this;
    }
    /**
     * Get ClCount value
     * @return int
     */
    public function getClCount()
    {
        return $this->ClCount;
    }
    /**
     * Set ClCount value
     * @param int $clCount
     * @return \StructType\ApiStatus
     */
    public function setClCount($clCount = null)
    {
        // validation for constraint: int
        if (!is_null($clCount) && !(is_int($clCount) || ctype_digit($clCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clCount, true), gettype($clCount)), __LINE__);
        }
        $this->ClCount = $clCount;
        return $this;
    }
    /**
     * Get CorelationCount value
     * @return int
     */
    public function getCorelationCount()
    {
        return $this->CorelationCount;
    }
    /**
     * Set CorelationCount value
     * @param int $corelationCount
     * @return \StructType\ApiStatus
     */
    public function setCorelationCount($corelationCount = null)
    {
        // validation for constraint: int
        if (!is_null($corelationCount) && !(is_int($corelationCount) || ctype_digit($corelationCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($corelationCount, true), gettype($corelationCount)), __LINE__);
        }
        $this->CorelationCount = $corelationCount;
        return $this;
    }
    /**
     * Get NearestPointCount value
     * @return int
     */
    public function getNearestPointCount()
    {
        return $this->NearestPointCount;
    }
    /**
     * Set NearestPointCount value
     * @param int $nearestPointCount
     * @return \StructType\ApiStatus
     */
    public function setNearestPointCount($nearestPointCount = null)
    {
        // validation for constraint: int
        if (!is_null($nearestPointCount) && !(is_int($nearestPointCount) || ctype_digit($nearestPointCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nearestPointCount, true), gettype($nearestPointCount)), __LINE__);
        }
        $this->NearestPointCount = $nearestPointCount;
        return $this;
    }
    /**
     * Get PostalCodeZoneCount value
     * @return int
     */
    public function getPostalCodeZoneCount()
    {
        return $this->PostalCodeZoneCount;
    }
    /**
     * Set PostalCodeZoneCount value
     * @param int $postalCodeZoneCount
     * @return \StructType\ApiStatus
     */
    public function setPostalCodeZoneCount($postalCodeZoneCount = null)
    {
        // validation for constraint: int
        if (!is_null($postalCodeZoneCount) && !(is_int($postalCodeZoneCount) || ctype_digit($postalCodeZoneCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($postalCodeZoneCount, true), gettype($postalCodeZoneCount)), __LINE__);
        }
        $this->PostalCodeZoneCount = $postalCodeZoneCount;
        return $this;
    }
    /**
     * Get TypeCount value
     * @return int
     */
    public function getTypeCount()
    {
        return $this->TypeCount;
    }
    /**
     * Set TypeCount value
     * @param int $typeCount
     * @return \StructType\ApiStatus
     */
    public function setTypeCount($typeCount = null)
    {
        // validation for constraint: int
        if (!is_null($typeCount) && !(is_int($typeCount) || ctype_digit($typeCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($typeCount, true), gettype($typeCount)), __LINE__);
        }
        $this->TypeCount = $typeCount;
        return $this;
    }
    /**
     * Get PermissionCount value
     * @return int
     */
    public function getPermissionCount()
    {
        return $this->PermissionCount;
    }
    /**
     * Set PermissionCount value
     * @param int $permissionCount
     * @return \StructType\ApiStatus
     */
    public function setPermissionCount($permissionCount = null)
    {
        // validation for constraint: int
        if (!is_null($permissionCount) && !(is_int($permissionCount) || ctype_digit($permissionCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($permissionCount, true), gettype($permissionCount)), __LINE__);
        }
        $this->PermissionCount = $permissionCount;
        return $this;
    }
    /**
     * Get SuggestionsCount value
     * @return int
     */
    public function getSuggestionsCount()
    {
        return $this->SuggestionsCount;
    }
    /**
     * Set SuggestionsCount value
     * @param int $suggestionsCount
     * @return \StructType\ApiStatus
     */
    public function setSuggestionsCount($suggestionsCount = null)
    {
        // validation for constraint: int
        if (!is_null($suggestionsCount) && !(is_int($suggestionsCount) || ctype_digit($suggestionsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($suggestionsCount, true), gettype($suggestionsCount)), __LINE__);
        }
        $this->SuggestionsCount = $suggestionsCount;
        return $this;
    }
    /**
     * Get DictionaryCount value
     * @return int
     */
    public function getDictionaryCount()
    {
        return $this->DictionaryCount;
    }
    /**
     * Set DictionaryCount value
     * @param int $dictionaryCount
     * @return \StructType\ApiStatus
     */
    public function setDictionaryCount($dictionaryCount = null)
    {
        // validation for constraint: int
        if (!is_null($dictionaryCount) && !(is_int($dictionaryCount) || ctype_digit($dictionaryCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dictionaryCount, true), gettype($dictionaryCount)), __LINE__);
        }
        $this->DictionaryCount = $dictionaryCount;
        return $this;
    }
    /**
     * Get LastRefresh value
     * @return string
     */
    public function getLastRefresh()
    {
        return $this->LastRefresh;
    }
    /**
     * Set LastRefresh value
     * @param string $lastRefresh
     * @return \StructType\ApiStatus
     */
    public function setLastRefresh($lastRefresh = null)
    {
        // validation for constraint: string
        if (!is_null($lastRefresh) && !is_string($lastRefresh)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastRefresh, true), gettype($lastRefresh)), __LINE__);
        }
        $this->LastRefresh = $lastRefresh;
        return $this;
    }
    /**
     * Get PartnerStatus value
     * @return \StructType\RedisCacheInfo|null
     */
    public function getPartnerStatus()
    {
        return $this->PartnerStatus;
    }
    /**
     * Set PartnerStatus value
     * @param \StructType\RedisCacheInfo $partnerStatus
     * @return \StructType\ApiStatus
     */
    public function setPartnerStatus(\StructType\RedisCacheInfo $partnerStatus = null)
    {
        $this->PartnerStatus = $partnerStatus;
        return $this;
    }
    /**
     * Get BuildNumber value
     * @return string|null
     */
    public function getBuildNumber()
    {
        return $this->BuildNumber;
    }
    /**
     * Set BuildNumber value
     * @param string $buildNumber
     * @return \StructType\ApiStatus
     */
    public function setBuildNumber($buildNumber = null)
    {
        // validation for constraint: string
        if (!is_null($buildNumber) && !is_string($buildNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buildNumber, true), gettype($buildNumber)), __LINE__);
        }
        $this->BuildNumber = $buildNumber;
        return $this;
    }
    /**
     * Get Feature value
     * @return string|null
     */
    public function getFeature()
    {
        return $this->Feature;
    }
    /**
     * Set Feature value
     * @param string $feature
     * @return \StructType\ApiStatus
     */
    public function setFeature($feature = null)
    {
        // validation for constraint: string
        if (!is_null($feature) && !is_string($feature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feature, true), gettype($feature)), __LINE__);
        }
        $this->Feature = $feature;
        return $this;
    }
}
