<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Customer ServiceType
 * @subpackage Services
 */
class Customer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CustomerConfirmPackReturn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CustomerConfirmPackReturn $parameters
     * @return \StructType\CustomerConfirmPackReturnResponse|bool
     */
    public function CustomerConfirmPackReturn(\StructType\CustomerConfirmPackReturn $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CustomerConfirmPackReturn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CustomerGetPackagesToBeReturned
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CustomerGetPackagesToBeReturned $parameters
     * @return \StructType\CustomerGetPackagesToBeReturnedResponse|bool
     */
    public function CustomerGetPackagesToBeReturned(\StructType\CustomerGetPackagesToBeReturned $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CustomerGetPackagesToBeReturned($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CustomerConfirmPackReturnResponse|\StructType\CustomerGetPackagesToBeReturnedResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
