<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Call ServiceType
 * @subpackage Services
 */
class Call extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CallPickup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CallPickup $parameters
     * @return \StructType\CallPickupResponse|bool
     */
    public function CallPickup(\StructType\CallPickup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CallPickup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CallPickupNew
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CallPickupNew $parameters
     * @return \StructType\CallPickupNewResponse|bool
     */
    public function CallPickupNew(\StructType\CallPickupNew $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CallPickupNew($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CallPickupNewResponse|\StructType\CallPickupResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
