<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPointPwR ArrayType
 * @subpackage Arrays
 */
class ArrayOfPointPwR extends AbstractStructArrayBase
{
    /**
     * The PointPwR
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PointPwR[]
     */
    public $PointPwR;
    /**
     * Constructor method for ArrayOfPointPwR
     * @uses ArrayOfPointPwR::setPointPwR()
     * @param \StructType\PointPwR[] $pointPwR
     */
    public function __construct(array $pointPwR = array())
    {
        $this
            ->setPointPwR($pointPwR);
    }
    /**
     * Get PointPwR value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PointPwR[]|null
     */
    public function getPointPwR()
    {
        return isset($this->PointPwR) ? $this->PointPwR : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPointPwR method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPointPwR method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePointPwRForArrayConstraintsFromSetPointPwR(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPointPwRPointPwRItem) {
            // validation for constraint: itemType
            if (!$arrayOfPointPwRPointPwRItem instanceof \StructType\PointPwR) {
                $invalidValues[] = is_object($arrayOfPointPwRPointPwRItem) ? get_class($arrayOfPointPwRPointPwRItem) : sprintf('%s(%s)', gettype($arrayOfPointPwRPointPwRItem), var_export($arrayOfPointPwRPointPwRItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PointPwR property can only contain items of type \StructType\PointPwR, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PointPwR value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PointPwR[] $pointPwR
     * @return \ArrayType\ArrayOfPointPwR
     */
    public function setPointPwR(array $pointPwR = array())
    {
        // validation for constraint: array
        if ('' !== ($pointPwRArrayErrorMessage = self::validatePointPwRForArrayConstraintsFromSetPointPwR($pointPwR))) {
            throw new \InvalidArgumentException($pointPwRArrayErrorMessage, __LINE__);
        }
        if (is_null($pointPwR) || (is_array($pointPwR) && empty($pointPwR))) {
            unset($this->PointPwR);
        } else {
            $this->PointPwR = $pointPwR;
        }
        return $this;
    }
    /**
     * Add item to PointPwR value
     * @throws \InvalidArgumentException
     * @param \StructType\PointPwR $item
     * @return \ArrayType\ArrayOfPointPwR
     */
    public function addToPointPwR(\StructType\PointPwR $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PointPwR) {
            throw new \InvalidArgumentException(sprintf('The PointPwR property can only contain items of type \StructType\PointPwR, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PointPwR[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PointPwR|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PointPwR|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PointPwR|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PointPwR|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PointPwR|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PointPwR
     */
    public function getAttributeName()
    {
        return 'PointPwR';
    }
}
