<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBusinessPack ArrayType
 * @subpackage Arrays
 */
class ArrayOfBusinessPack extends AbstractStructArrayBase
{
    /**
     * The BusinessPack
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BusinessPack[]
     */
    public $BusinessPack;
    /**
     * Constructor method for ArrayOfBusinessPack
     * @uses ArrayOfBusinessPack::setBusinessPack()
     * @param \StructType\BusinessPack[] $businessPack
     */
    public function __construct(array $businessPack = array())
    {
        $this
            ->setBusinessPack($businessPack);
    }
    /**
     * Get BusinessPack value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BusinessPack[]|null
     */
    public function getBusinessPack()
    {
        return isset($this->BusinessPack) ? $this->BusinessPack : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBusinessPack method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusinessPack method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusinessPackForArrayConstraintsFromSetBusinessPack(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBusinessPackBusinessPackItem) {
            // validation for constraint: itemType
            if (!$arrayOfBusinessPackBusinessPackItem instanceof \StructType\BusinessPack) {
                $invalidValues[] = is_object($arrayOfBusinessPackBusinessPackItem) ? get_class($arrayOfBusinessPackBusinessPackItem) : sprintf('%s(%s)', gettype($arrayOfBusinessPackBusinessPackItem), var_export($arrayOfBusinessPackBusinessPackItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BusinessPack property can only contain items of type \StructType\BusinessPack, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BusinessPack value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessPack[] $businessPack
     * @return \ArrayType\ArrayOfBusinessPack
     */
    public function setBusinessPack(array $businessPack = array())
    {
        // validation for constraint: array
        if ('' !== ($businessPackArrayErrorMessage = self::validateBusinessPackForArrayConstraintsFromSetBusinessPack($businessPack))) {
            throw new \InvalidArgumentException($businessPackArrayErrorMessage, __LINE__);
        }
        if (is_null($businessPack) || (is_array($businessPack) && empty($businessPack))) {
            unset($this->BusinessPack);
        } else {
            $this->BusinessPack = $businessPack;
        }
        return $this;
    }
    /**
     * Add item to BusinessPack value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessPack $item
     * @return \ArrayType\ArrayOfBusinessPack
     */
    public function addToBusinessPack(\StructType\BusinessPack $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BusinessPack) {
            throw new \InvalidArgumentException(sprintf('The BusinessPack property can only contain items of type \StructType\BusinessPack, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BusinessPack[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BusinessPack|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BusinessPack|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BusinessPack|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BusinessPack|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BusinessPack|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BusinessPack
     */
    public function getAttributeName()
    {
        return 'BusinessPack';
    }
}
