<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.orlenpaczka.pl/WebServicePwRProd/WebServicePwR.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.orlenpaczka.pl/WebServicePwRProd/WebServicePwR.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Ping ServiceType
 */
$ping = new \ServiceType\Ping($options);
/**
 * Sample call for Ping operation/method
 */
if ($ping->Ping(new \StructType\Ping()) !== false) {
    print_r($ping->getResult());
} else {
    print_r($ping->getLastError());
}
/**
 * Samples for Is ServiceType
 */
$is = new \ServiceType\Is($options);
/**
 * Sample call for IsDataPopulated operation/method
 */
if ($is->IsDataPopulated(new \StructType\IsDataPopulated()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Samples for Give ServiceType
 */
$give = new \ServiceType\Give($options);
/**
 * Sample call for GiveMePackStatusFullHistoryList operation/method
 */
if ($give->GiveMePackStatusFullHistoryList(new \StructType\GiveMePackStatusFullHistoryList()) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Sample call for GiveMePackStatusFullHistory operation/method
 */
if ($give->GiveMePackStatusFullHistory(new \StructType\GiveMePackStatusFullHistory()) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Sample call for GiveMeShippingCodeStatusFullHistory operation/method
 */
if ($give->GiveMeShippingCodeStatusFullHistory(new \StructType\GiveMeShippingCodeStatusFullHistory()) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Sample call for GiveMePackStatus operation/method
 */
if ($give->GiveMePackStatus(new \StructType\GiveMePackStatus()) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Sample call for GiveMePackStatusList operation/method
 */
if ($give->GiveMePackStatusList(new \StructType\GiveMePackStatusList()) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Sample call for GiveMasterPack operation/method
 */
if ($give->GiveMasterPack(new \StructType\GiveMasterPack()) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Sample call for GiveCurrentPack operation/method
 */
if ($give->GiveCurrentPack(new \StructType\GiveCurrentPack()) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Sample call for GiveMeAllRUCHWithFilled operation/method
 */
if ($give->GiveMeAllRUCHWithFilled(new \StructType\GiveMeAllRUCHWithFilled()) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Sample call for GiveMeAllRUCHWithFilledD1 operation/method
 */
if ($give->GiveMeAllRUCHWithFilledD1(new \StructType\GiveMeAllRUCHWithFilledD1()) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Sample call for GiveMeAllRUCHZipcode operation/method
 */
if ($give->GiveMeAllRUCHZipcode(new \StructType\GiveMeAllRUCHZipcode()) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Sample call for GiveMeAllRUCHLocation operation/method
 */
if ($give->GiveMeAllRUCHLocation(new \StructType\GiveMeAllRUCHLocation()) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Sample call for GiveMeAllPSDLocation operation/method
 */
if ($give->GiveMeAllPSDLocation(new \StructType\GiveMeAllPSDLocation()) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Sample call for GiveMeAllLocationWithAllData operation/method
 */
if ($give->GiveMeAllLocationWithAllData(new \StructType\GiveMeAllLocationWithAllData()) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Sample call for GiveMeAllApmLocation operation/method
 */
if ($give->GiveMeAllApmLocation(new \StructType\GiveMeAllApmLocation()) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Sample call for GiveMePSDProvince operation/method
 */
if ($give->GiveMePSDProvince(new \StructType\GiveMePSDProvince()) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Sample call for GiveMePSDZipcode operation/method
 */
if ($give->GiveMePSDZipcode(new \StructType\GiveMePSDZipcode()) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Sample call for GiveMeCityPSDLocation operation/method
 */
if ($give->GiveMeCityPSDLocation(new \StructType\GiveMeCityPSDLocation()) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Sample call for GivePaymentType operation/method
 */
if ($give->GivePaymentType(new \StructType\GivePaymentType()) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Sample call for GivePartnerStatus operation/method
 */
if ($give->GivePartnerStatus(new \StructType\GivePartnerStatus()) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Sample call for GivePartnerStatusWithAllData operation/method
 */
if ($give->GivePartnerStatusWithAllData(new \StructType\GivePartnerStatusWithAllData()) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Sample call for GiveShippingCodeStatus operation/method
 */
if ($give->GiveShippingCodeStatus(new \StructType\GiveShippingCodeStatus()) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Samples for Generate ServiceType
 */
$generate = new \ServiceType\Generate($options);
/**
 * Sample call for GenerateBusinessPack operation/method
 */
if ($generate->GenerateBusinessPack(new \StructType\GenerateBusinessPack()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateBusinessPackTwo operation/method
 */
if ($generate->GenerateBusinessPackTwo(new \StructType\GenerateBusinessPackTwo()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateNumberWaybills operation/method
 */
if ($generate->GenerateNumberWaybills(new \StructType\GenerateNumberWaybills()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateLabelBusinessPackList operation/method
 */
if ($generate->GenerateLabelBusinessPackList(new \StructType\GenerateLabelBusinessPackList()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateLabelBusinessPackListTwo operation/method
 */
if ($generate->GenerateLabelBusinessPackListTwo(new \StructType\GenerateLabelBusinessPackListTwo()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateLabelBusinessPack operation/method
 */
if ($generate->GenerateLabelBusinessPack(new \StructType\GenerateLabelBusinessPack()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateLabelBusinessPackTwo operation/method
 */
if ($generate->GenerateLabelBusinessPackTwo(new \StructType\GenerateLabelBusinessPackTwo()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateProtocol operation/method
 */
if ($generate->GenerateProtocol(new \StructType\GenerateProtocol()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateShippingCode operation/method
 */
if ($generate->GenerateShippingCode(new \StructType\GenerateShippingCode()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateShippingCodeRuch2Home operation/method
 */
if ($generate->GenerateShippingCodeRuch2Home(new \StructType\GenerateShippingCodeRuch2Home()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateLabelBusinessPackRuch2Home operation/method
 */
if ($generate->GenerateLabelBusinessPackRuch2Home(new \StructType\GenerateLabelBusinessPackRuch2Home()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateLabelBusinessPackAllegro operation/method
 */
if ($generate->GenerateLabelBusinessPackAllegro(new \StructType\GenerateLabelBusinessPackAllegro()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateLabelBusinessPackListAllegro operation/method
 */
if ($generate->GenerateLabelBusinessPackListAllegro(new \StructType\GenerateLabelBusinessPackListAllegro()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateCustomerReturn operation/method
 */
if ($generate->GenerateCustomerReturn(new \StructType\GenerateCustomerReturn()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateCustomerReturnShippingCode operation/method
 */
if ($generate->GenerateCustomerReturnShippingCode(new \StructType\GenerateCustomerReturnShippingCode()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Samples for Put ServiceType
 */
$put = new \ServiceType\Put($options);
/**
 * Sample call for PutCustomerPackCanceled operation/method
 */
if ($put->PutCustomerPackCanceled(new \StructType\PutCustomerPackCanceled()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for PutCustomerShippingCodeCanceled operation/method
 */
if ($put->PutCustomerShippingCodeCanceled(new \StructType\PutCustomerShippingCodeCanceled()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Sample call for PutCustomerPack operation/method
 */
if ($put->PutCustomerPack(new \StructType\PutCustomerPack()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for CreateCustomer operation/method
 */
if ($create->CreateCustomer(new \StructType\CreateCustomer()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetGeneratedParcels operation/method
 */
if ($get->GetGeneratedParcels(new \StructType\GetGeneratedParcels()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailablePickups operation/method
 */
if ($get->GetAvailablePickups(new \StructType\GetAvailablePickups()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Label ServiceType
 */
$label = new \ServiceType\Label($options);
/**
 * Sample call for LabelPrintDuplicateList operation/method
 */
if ($label->LabelPrintDuplicateList(new \StructType\LabelPrintDuplicateList()) !== false) {
    print_r($label->getResult());
} else {
    print_r($label->getLastError());
}
/**
 * Sample call for LabelPrintDuplicateListTwo operation/method
 */
if ($label->LabelPrintDuplicateListTwo(new \StructType\LabelPrintDuplicateListTwo()) !== false) {
    print_r($label->getResult());
} else {
    print_r($label->getLastError());
}
/**
 * Sample call for LabelPrintDuplicate operation/method
 */
if ($label->LabelPrintDuplicate(new \StructType\LabelPrintDuplicate()) !== false) {
    print_r($label->getResult());
} else {
    print_r($label->getLastError());
}
/**
 * Sample call for LabelPrintDuplicateTwo operation/method
 */
if ($label->LabelPrintDuplicateTwo(new \StructType\LabelPrintDuplicateTwo()) !== false) {
    print_r($label->getResult());
} else {
    print_r($label->getLastError());
}
/**
 * Samples for Customer ServiceType
 */
$customer = new \ServiceType\Customer($options);
/**
 * Sample call for CustomerConfirmPackReturn operation/method
 */
if ($customer->CustomerConfirmPackReturn(new \StructType\CustomerConfirmPackReturn()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Sample call for CustomerGetPackagesToBeReturned operation/method
 */
if ($customer->CustomerGetPackagesToBeReturned(new \StructType\CustomerGetPackagesToBeReturned()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Samples for Call ServiceType
 */
$call = new \ServiceType\Call($options);
/**
 * Sample call for CallPickup operation/method
 */
if ($call->CallPickup(new \StructType\CallPickup()) !== false) {
    print_r($call->getResult());
} else {
    print_r($call->getLastError());
}
/**
 * Sample call for CallPickupNew operation/method
 */
if ($call->CallPickupNew(new \StructType\CallPickupNew()) !== false) {
    print_r($call->getResult());
} else {
    print_r($call->getLastError());
}
/**
 * Samples for Order ServiceType
 */
$order = new \ServiceType\Order($options);
/**
 * Sample call for OrderPickupsFromLastDays operation/method
 */
if ($order->OrderPickupsFromLastDays(new \StructType\OrderPickupsFromLastDays()) !== false) {
    print_r($order->getResult());
} else {
    print_r($order->getLastError());
}
