<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PutCustomerShippingCodeCanceled StructType
 * @subpackage Structs
 */
class PutCustomerShippingCodeCanceled extends AbstractStructBase
{
    /**
     * The ShippingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShippingCode;
    /**
     * The PartnerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerID;
    /**
     * The PartnerKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerKey;
    /**
     * Constructor method for PutCustomerShippingCodeCanceled
     * @uses PutCustomerShippingCodeCanceled::setShippingCode()
     * @uses PutCustomerShippingCodeCanceled::setPartnerID()
     * @uses PutCustomerShippingCodeCanceled::setPartnerKey()
     * @param string $shippingCode
     * @param string $partnerID
     * @param string $partnerKey
     */
    public function __construct($shippingCode = null, $partnerID = null, $partnerKey = null)
    {
        $this
            ->setShippingCode($shippingCode)
            ->setPartnerID($partnerID)
            ->setPartnerKey($partnerKey);
    }
    /**
     * Get ShippingCode value
     * @return string|null
     */
    public function getShippingCode()
    {
        return $this->ShippingCode;
    }
    /**
     * Set ShippingCode value
     * @param string $shippingCode
     * @return \StructType\PutCustomerShippingCodeCanceled
     */
    public function setShippingCode($shippingCode = null)
    {
        // validation for constraint: string
        if (!is_null($shippingCode) && !is_string($shippingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingCode, true), gettype($shippingCode)), __LINE__);
        }
        $this->ShippingCode = $shippingCode;
        return $this;
    }
    /**
     * Get PartnerID value
     * @return string|null
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }
    /**
     * Set PartnerID value
     * @param string $partnerID
     * @return \StructType\PutCustomerShippingCodeCanceled
     */
    public function setPartnerID($partnerID = null)
    {
        // validation for constraint: string
        if (!is_null($partnerID) && !is_string($partnerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerID, true), gettype($partnerID)), __LINE__);
        }
        $this->PartnerID = $partnerID;
        return $this;
    }
    /**
     * Get PartnerKey value
     * @return string|null
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }
    /**
     * Set PartnerKey value
     * @param string $partnerKey
     * @return \StructType\PutCustomerShippingCodeCanceled
     */
    public function setPartnerKey($partnerKey = null)
    {
        // validation for constraint: string
        if (!is_null($partnerKey) && !is_string($partnerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerKey, true), gettype($partnerKey)), __LINE__);
        }
        $this->PartnerKey = $partnerKey;
        return $this;
    }
}
