<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelPrintDuplicateTwo StructType
 * @subpackage Structs
 */
class LabelPrintDuplicateTwo extends AbstractStructBase
{
    /**
     * The Format
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Format;
    /**
     * The PartnerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerID;
    /**
     * The PartnerKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerKey;
    /**
     * The PackCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PackCode;
    /**
     * Constructor method for LabelPrintDuplicateTwo
     * @uses LabelPrintDuplicateTwo::setFormat()
     * @uses LabelPrintDuplicateTwo::setPartnerID()
     * @uses LabelPrintDuplicateTwo::setPartnerKey()
     * @uses LabelPrintDuplicateTwo::setPackCode()
     * @param string $format
     * @param string $partnerID
     * @param string $partnerKey
     * @param string $packCode
     */
    public function __construct($format = null, $partnerID = null, $partnerKey = null, $packCode = null)
    {
        $this
            ->setFormat($format)
            ->setPartnerID($partnerID)
            ->setPartnerKey($partnerKey)
            ->setPackCode($packCode);
    }
    /**
     * Get Format value
     * @return string
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @uses \EnumType\FormatPliku3::valueIsValid()
     * @uses \EnumType\FormatPliku3::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $format
     * @return \StructType\LabelPrintDuplicateTwo
     */
    public function setFormat($format = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FormatPliku3::valueIsValid($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FormatPliku3', is_array($format) ? implode(', ', $format) : var_export($format, true), implode(', ', \EnumType\FormatPliku3::getValidValues())), __LINE__);
        }
        $this->Format = $format;
        return $this;
    }
    /**
     * Get PartnerID value
     * @return string|null
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }
    /**
     * Set PartnerID value
     * @param string $partnerID
     * @return \StructType\LabelPrintDuplicateTwo
     */
    public function setPartnerID($partnerID = null)
    {
        // validation for constraint: string
        if (!is_null($partnerID) && !is_string($partnerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerID, true), gettype($partnerID)), __LINE__);
        }
        $this->PartnerID = $partnerID;
        return $this;
    }
    /**
     * Get PartnerKey value
     * @return string|null
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }
    /**
     * Set PartnerKey value
     * @param string $partnerKey
     * @return \StructType\LabelPrintDuplicateTwo
     */
    public function setPartnerKey($partnerKey = null)
    {
        // validation for constraint: string
        if (!is_null($partnerKey) && !is_string($partnerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerKey, true), gettype($partnerKey)), __LINE__);
        }
        $this->PartnerKey = $partnerKey;
        return $this;
    }
    /**
     * Get PackCode value
     * @return string|null
     */
    public function getPackCode()
    {
        return $this->PackCode;
    }
    /**
     * Set PackCode value
     * @param string $packCode
     * @return \StructType\LabelPrintDuplicateTwo
     */
    public function setPackCode($packCode = null)
    {
        // validation for constraint: string
        if (!is_null($packCode) && !is_string($packCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packCode, true), gettype($packCode)), __LINE__);
        }
        $this->PackCode = $packCode;
        return $this;
    }
}
