<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiveMePackStatusList StructType
 * @subpackage Structs
 */
class GiveMePackStatusList extends AbstractStructBase
{
    /**
     * The PackCodes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $PackCodes;
    /**
     * The PartnerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerID;
    /**
     * The PartnerKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerKey;
    /**
     * Constructor method for GiveMePackStatusList
     * @uses GiveMePackStatusList::setPackCodes()
     * @uses GiveMePackStatusList::setPartnerID()
     * @uses GiveMePackStatusList::setPartnerKey()
     * @param \ArrayType\ArrayOfString $packCodes
     * @param string $partnerID
     * @param string $partnerKey
     */
    public function __construct(\ArrayType\ArrayOfString $packCodes = null, $partnerID = null, $partnerKey = null)
    {
        $this
            ->setPackCodes($packCodes)
            ->setPartnerID($partnerID)
            ->setPartnerKey($partnerKey);
    }
    /**
     * Get PackCodes value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getPackCodes()
    {
        return $this->PackCodes;
    }
    /**
     * Set PackCodes value
     * @param \ArrayType\ArrayOfString $packCodes
     * @return \StructType\GiveMePackStatusList
     */
    public function setPackCodes(\ArrayType\ArrayOfString $packCodes = null)
    {
        $this->PackCodes = $packCodes;
        return $this;
    }
    /**
     * Get PartnerID value
     * @return string|null
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }
    /**
     * Set PartnerID value
     * @param string $partnerID
     * @return \StructType\GiveMePackStatusList
     */
    public function setPartnerID($partnerID = null)
    {
        // validation for constraint: string
        if (!is_null($partnerID) && !is_string($partnerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerID, true), gettype($partnerID)), __LINE__);
        }
        $this->PartnerID = $partnerID;
        return $this;
    }
    /**
     * Get PartnerKey value
     * @return string|null
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }
    /**
     * Set PartnerKey value
     * @param string $partnerKey
     * @return \StructType\GiveMePackStatusList
     */
    public function setPartnerKey($partnerKey = null)
    {
        // validation for constraint: string
        if (!is_null($partnerKey) && !is_string($partnerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerKey, true), gettype($partnerKey)), __LINE__);
        }
        $this->PartnerKey = $partnerKey;
        return $this;
    }
}
