<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenerateProtocol StructType
 * @subpackage Structs
 */
class GenerateProtocol extends AbstractStructBase
{
    /**
     * The PartnerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerID;
    /**
     * The PartnerKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerKey;
    /**
     * The parcels
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfUnsignedLong
     */
    public $parcels;
    /**
     * Constructor method for GenerateProtocol
     * @uses GenerateProtocol::setPartnerID()
     * @uses GenerateProtocol::setPartnerKey()
     * @uses GenerateProtocol::setParcels()
     * @param string $partnerID
     * @param string $partnerKey
     * @param \ArrayType\ArrayOfUnsignedLong $parcels
     */
    public function __construct($partnerID = null, $partnerKey = null, \ArrayType\ArrayOfUnsignedLong $parcels = null)
    {
        $this
            ->setPartnerID($partnerID)
            ->setPartnerKey($partnerKey)
            ->setParcels($parcels);
    }
    /**
     * Get PartnerID value
     * @return string|null
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }
    /**
     * Set PartnerID value
     * @param string $partnerID
     * @return \StructType\GenerateProtocol
     */
    public function setPartnerID($partnerID = null)
    {
        // validation for constraint: string
        if (!is_null($partnerID) && !is_string($partnerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerID, true), gettype($partnerID)), __LINE__);
        }
        $this->PartnerID = $partnerID;
        return $this;
    }
    /**
     * Get PartnerKey value
     * @return string|null
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }
    /**
     * Set PartnerKey value
     * @param string $partnerKey
     * @return \StructType\GenerateProtocol
     */
    public function setPartnerKey($partnerKey = null)
    {
        // validation for constraint: string
        if (!is_null($partnerKey) && !is_string($partnerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerKey, true), gettype($partnerKey)), __LINE__);
        }
        $this->PartnerKey = $partnerKey;
        return $this;
    }
    /**
     * Get parcels value
     * @return \ArrayType\ArrayOfUnsignedLong|null
     */
    public function getParcels()
    {
        return $this->parcels;
    }
    /**
     * Set parcels value
     * @param \ArrayType\ArrayOfUnsignedLong $parcels
     * @return \StructType\GenerateProtocol
     */
    public function setParcels(\ArrayType\ArrayOfUnsignedLong $parcels = null)
    {
        $this->parcels = $parcels;
        return $this;
    }
}
