<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenerateNumberWaybills StructType
 * @subpackage Structs
 */
class GenerateNumberWaybills extends AbstractStructBase
{
    /**
     * The PartnerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerID;
    /**
     * The PartnerKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerKey;
    /**
     * The NumberOfWaybills
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumberOfWaybills;
    /**
     * Constructor method for GenerateNumberWaybills
     * @uses GenerateNumberWaybills::setPartnerID()
     * @uses GenerateNumberWaybills::setPartnerKey()
     * @uses GenerateNumberWaybills::setNumberOfWaybills()
     * @param string $partnerID
     * @param string $partnerKey
     * @param string $numberOfWaybills
     */
    public function __construct($partnerID = null, $partnerKey = null, $numberOfWaybills = null)
    {
        $this
            ->setPartnerID($partnerID)
            ->setPartnerKey($partnerKey)
            ->setNumberOfWaybills($numberOfWaybills);
    }
    /**
     * Get PartnerID value
     * @return string|null
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }
    /**
     * Set PartnerID value
     * @param string $partnerID
     * @return \StructType\GenerateNumberWaybills
     */
    public function setPartnerID($partnerID = null)
    {
        // validation for constraint: string
        if (!is_null($partnerID) && !is_string($partnerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerID, true), gettype($partnerID)), __LINE__);
        }
        $this->PartnerID = $partnerID;
        return $this;
    }
    /**
     * Get PartnerKey value
     * @return string|null
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }
    /**
     * Set PartnerKey value
     * @param string $partnerKey
     * @return \StructType\GenerateNumberWaybills
     */
    public function setPartnerKey($partnerKey = null)
    {
        // validation for constraint: string
        if (!is_null($partnerKey) && !is_string($partnerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerKey, true), gettype($partnerKey)), __LINE__);
        }
        $this->PartnerKey = $partnerKey;
        return $this;
    }
    /**
     * Get NumberOfWaybills value
     * @return string|null
     */
    public function getNumberOfWaybills()
    {
        return $this->NumberOfWaybills;
    }
    /**
     * Set NumberOfWaybills value
     * @param string $numberOfWaybills
     * @return \StructType\GenerateNumberWaybills
     */
    public function setNumberOfWaybills($numberOfWaybills = null)
    {
        // validation for constraint: string
        if (!is_null($numberOfWaybills) && !is_string($numberOfWaybills)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberOfWaybills, true), gettype($numberOfWaybills)), __LINE__);
        }
        $this->NumberOfWaybills = $numberOfWaybills;
        return $this;
    }
}
