<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenerateCustomerReturn StructType
 * @subpackage Structs
 */
class GenerateCustomerReturn extends AbstractStructBase
{
    /**
     * The PartnerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerID;
    /**
     * The PartnerKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerKey;
    /**
     * The PackCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PackCode;
    /**
     * The SenderPhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderPhoneNumber;
    /**
     * Constructor method for GenerateCustomerReturn
     * @uses GenerateCustomerReturn::setPartnerID()
     * @uses GenerateCustomerReturn::setPartnerKey()
     * @uses GenerateCustomerReturn::setPackCode()
     * @uses GenerateCustomerReturn::setSenderPhoneNumber()
     * @param string $partnerID
     * @param string $partnerKey
     * @param string $packCode
     * @param string $senderPhoneNumber
     */
    public function __construct($partnerID = null, $partnerKey = null, $packCode = null, $senderPhoneNumber = null)
    {
        $this
            ->setPartnerID($partnerID)
            ->setPartnerKey($partnerKey)
            ->setPackCode($packCode)
            ->setSenderPhoneNumber($senderPhoneNumber);
    }
    /**
     * Get PartnerID value
     * @return string|null
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }
    /**
     * Set PartnerID value
     * @param string $partnerID
     * @return \StructType\GenerateCustomerReturn
     */
    public function setPartnerID($partnerID = null)
    {
        // validation for constraint: string
        if (!is_null($partnerID) && !is_string($partnerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerID, true), gettype($partnerID)), __LINE__);
        }
        $this->PartnerID = $partnerID;
        return $this;
    }
    /**
     * Get PartnerKey value
     * @return string|null
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }
    /**
     * Set PartnerKey value
     * @param string $partnerKey
     * @return \StructType\GenerateCustomerReturn
     */
    public function setPartnerKey($partnerKey = null)
    {
        // validation for constraint: string
        if (!is_null($partnerKey) && !is_string($partnerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerKey, true), gettype($partnerKey)), __LINE__);
        }
        $this->PartnerKey = $partnerKey;
        return $this;
    }
    /**
     * Get PackCode value
     * @return string|null
     */
    public function getPackCode()
    {
        return $this->PackCode;
    }
    /**
     * Set PackCode value
     * @param string $packCode
     * @return \StructType\GenerateCustomerReturn
     */
    public function setPackCode($packCode = null)
    {
        // validation for constraint: string
        if (!is_null($packCode) && !is_string($packCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packCode, true), gettype($packCode)), __LINE__);
        }
        $this->PackCode = $packCode;
        return $this;
    }
    /**
     * Get SenderPhoneNumber value
     * @return string|null
     */
    public function getSenderPhoneNumber()
    {
        return $this->SenderPhoneNumber;
    }
    /**
     * Set SenderPhoneNumber value
     * @param string $senderPhoneNumber
     * @return \StructType\GenerateCustomerReturn
     */
    public function setSenderPhoneNumber($senderPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($senderPhoneNumber) && !is_string($senderPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderPhoneNumber, true), gettype($senderPhoneNumber)), __LINE__);
        }
        $this->SenderPhoneNumber = $senderPhoneNumber;
        return $this;
    }
}
