<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusinessPackAllegro StructType
 * @subpackage Structs
 */
class BusinessPackAllegro extends BusinessPack
{
    /**
     * The AllegroId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AllegroId;
    /**
     * The AllegroOrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AllegroOrderId;
    /**
     * The AllegroCustomerLogin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AllegroCustomerLogin;
    /**
     * The AllegroTransactionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AllegroTransactionId;
    /**
     * The AllegroSellerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AllegroSellerId;
    /**
     * The AllegroDealId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AllegroDealId;
    /**
     * The AllegroDeliveryType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AllegroDeliveryType;
    /**
     * The AllegroPaymentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AllegroPaymentType;
    /**
     * The AllegroSendVerified
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AllegroSendVerified;
    /**
     * Constructor method for BusinessPackAllegro
     * @uses BusinessPackAllegro::setAllegroId()
     * @uses BusinessPackAllegro::setAllegroOrderId()
     * @uses BusinessPackAllegro::setAllegroCustomerLogin()
     * @uses BusinessPackAllegro::setAllegroTransactionId()
     * @uses BusinessPackAllegro::setAllegroSellerId()
     * @uses BusinessPackAllegro::setAllegroDealId()
     * @uses BusinessPackAllegro::setAllegroDeliveryType()
     * @uses BusinessPackAllegro::setAllegroPaymentType()
     * @uses BusinessPackAllegro::setAllegroSendVerified()
     * @param string $allegroId
     * @param string $allegroOrderId
     * @param string $allegroCustomerLogin
     * @param string $allegroTransactionId
     * @param string $allegroSellerId
     * @param string $allegroDealId
     * @param string $allegroDeliveryType
     * @param string $allegroPaymentType
     * @param string $allegroSendVerified
     */
    public function __construct($allegroId = null, $allegroOrderId = null, $allegroCustomerLogin = null, $allegroTransactionId = null, $allegroSellerId = null, $allegroDealId = null, $allegroDeliveryType = null, $allegroPaymentType = null, $allegroSendVerified = null)
    {
        $this
            ->setAllegroId($allegroId)
            ->setAllegroOrderId($allegroOrderId)
            ->setAllegroCustomerLogin($allegroCustomerLogin)
            ->setAllegroTransactionId($allegroTransactionId)
            ->setAllegroSellerId($allegroSellerId)
            ->setAllegroDealId($allegroDealId)
            ->setAllegroDeliveryType($allegroDeliveryType)
            ->setAllegroPaymentType($allegroPaymentType)
            ->setAllegroSendVerified($allegroSendVerified);
    }
    /**
     * Get AllegroId value
     * @return string|null
     */
    public function getAllegroId()
    {
        return $this->AllegroId;
    }
    /**
     * Set AllegroId value
     * @param string $allegroId
     * @return \StructType\BusinessPackAllegro
     */
    public function setAllegroId($allegroId = null)
    {
        // validation for constraint: string
        if (!is_null($allegroId) && !is_string($allegroId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allegroId, true), gettype($allegroId)), __LINE__);
        }
        $this->AllegroId = $allegroId;
        return $this;
    }
    /**
     * Get AllegroOrderId value
     * @return string|null
     */
    public function getAllegroOrderId()
    {
        return $this->AllegroOrderId;
    }
    /**
     * Set AllegroOrderId value
     * @param string $allegroOrderId
     * @return \StructType\BusinessPackAllegro
     */
    public function setAllegroOrderId($allegroOrderId = null)
    {
        // validation for constraint: string
        if (!is_null($allegroOrderId) && !is_string($allegroOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allegroOrderId, true), gettype($allegroOrderId)), __LINE__);
        }
        $this->AllegroOrderId = $allegroOrderId;
        return $this;
    }
    /**
     * Get AllegroCustomerLogin value
     * @return string|null
     */
    public function getAllegroCustomerLogin()
    {
        return $this->AllegroCustomerLogin;
    }
    /**
     * Set AllegroCustomerLogin value
     * @param string $allegroCustomerLogin
     * @return \StructType\BusinessPackAllegro
     */
    public function setAllegroCustomerLogin($allegroCustomerLogin = null)
    {
        // validation for constraint: string
        if (!is_null($allegroCustomerLogin) && !is_string($allegroCustomerLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allegroCustomerLogin, true), gettype($allegroCustomerLogin)), __LINE__);
        }
        $this->AllegroCustomerLogin = $allegroCustomerLogin;
        return $this;
    }
    /**
     * Get AllegroTransactionId value
     * @return string|null
     */
    public function getAllegroTransactionId()
    {
        return $this->AllegroTransactionId;
    }
    /**
     * Set AllegroTransactionId value
     * @param string $allegroTransactionId
     * @return \StructType\BusinessPackAllegro
     */
    public function setAllegroTransactionId($allegroTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($allegroTransactionId) && !is_string($allegroTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allegroTransactionId, true), gettype($allegroTransactionId)), __LINE__);
        }
        $this->AllegroTransactionId = $allegroTransactionId;
        return $this;
    }
    /**
     * Get AllegroSellerId value
     * @return string|null
     */
    public function getAllegroSellerId()
    {
        return $this->AllegroSellerId;
    }
    /**
     * Set AllegroSellerId value
     * @param string $allegroSellerId
     * @return \StructType\BusinessPackAllegro
     */
    public function setAllegroSellerId($allegroSellerId = null)
    {
        // validation for constraint: string
        if (!is_null($allegroSellerId) && !is_string($allegroSellerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allegroSellerId, true), gettype($allegroSellerId)), __LINE__);
        }
        $this->AllegroSellerId = $allegroSellerId;
        return $this;
    }
    /**
     * Get AllegroDealId value
     * @return string|null
     */
    public function getAllegroDealId()
    {
        return $this->AllegroDealId;
    }
    /**
     * Set AllegroDealId value
     * @param string $allegroDealId
     * @return \StructType\BusinessPackAllegro
     */
    public function setAllegroDealId($allegroDealId = null)
    {
        // validation for constraint: string
        if (!is_null($allegroDealId) && !is_string($allegroDealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allegroDealId, true), gettype($allegroDealId)), __LINE__);
        }
        $this->AllegroDealId = $allegroDealId;
        return $this;
    }
    /**
     * Get AllegroDeliveryType value
     * @return string|null
     */
    public function getAllegroDeliveryType()
    {
        return $this->AllegroDeliveryType;
    }
    /**
     * Set AllegroDeliveryType value
     * @param string $allegroDeliveryType
     * @return \StructType\BusinessPackAllegro
     */
    public function setAllegroDeliveryType($allegroDeliveryType = null)
    {
        // validation for constraint: string
        if (!is_null($allegroDeliveryType) && !is_string($allegroDeliveryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allegroDeliveryType, true), gettype($allegroDeliveryType)), __LINE__);
        }
        $this->AllegroDeliveryType = $allegroDeliveryType;
        return $this;
    }
    /**
     * Get AllegroPaymentType value
     * @return string|null
     */
    public function getAllegroPaymentType()
    {
        return $this->AllegroPaymentType;
    }
    /**
     * Set AllegroPaymentType value
     * @param string $allegroPaymentType
     * @return \StructType\BusinessPackAllegro
     */
    public function setAllegroPaymentType($allegroPaymentType = null)
    {
        // validation for constraint: string
        if (!is_null($allegroPaymentType) && !is_string($allegroPaymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allegroPaymentType, true), gettype($allegroPaymentType)), __LINE__);
        }
        $this->AllegroPaymentType = $allegroPaymentType;
        return $this;
    }
    /**
     * Get AllegroSendVerified value
     * @return string|null
     */
    public function getAllegroSendVerified()
    {
        return $this->AllegroSendVerified;
    }
    /**
     * Set AllegroSendVerified value
     * @param string $allegroSendVerified
     * @return \StructType\BusinessPackAllegro
     */
    public function setAllegroSendVerified($allegroSendVerified = null)
    {
        // validation for constraint: string
        if (!is_null($allegroSendVerified) && !is_string($allegroSendVerified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allegroSendVerified, true), gettype($allegroSendVerified)), __LINE__);
        }
        $this->AllegroSendVerified = $allegroSendVerified;
        return $this;
    }
}
