<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailablePickupDay StructType
 * @subpackage Structs
 */
class AvailablePickupDay extends AbstractStructBase
{
    /**
     * The MinimumInterval
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MinimumInterval;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The MinReadyDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MinReadyDate;
    /**
     * The MaxPickupDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MaxPickupDate;
    /**
     * Constructor method for AvailablePickupDay
     * @uses AvailablePickupDay::setMinimumInterval()
     * @uses AvailablePickupDay::setDate()
     * @uses AvailablePickupDay::setMinReadyDate()
     * @uses AvailablePickupDay::setMaxPickupDate()
     * @param int $minimumInterval
     * @param string $date
     * @param string $minReadyDate
     * @param string $maxPickupDate
     */
    public function __construct($minimumInterval = null, $date = null, $minReadyDate = null, $maxPickupDate = null)
    {
        $this
            ->setMinimumInterval($minimumInterval)
            ->setDate($date)
            ->setMinReadyDate($minReadyDate)
            ->setMaxPickupDate($maxPickupDate);
    }
    /**
     * Get MinimumInterval value
     * @return int
     */
    public function getMinimumInterval()
    {
        return $this->MinimumInterval;
    }
    /**
     * Set MinimumInterval value
     * @param int $minimumInterval
     * @return \StructType\AvailablePickupDay
     */
    public function setMinimumInterval($minimumInterval = null)
    {
        // validation for constraint: int
        if (!is_null($minimumInterval) && !(is_int($minimumInterval) || ctype_digit($minimumInterval))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimumInterval, true), gettype($minimumInterval)), __LINE__);
        }
        $this->MinimumInterval = $minimumInterval;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\AvailablePickupDay
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get MinReadyDate value
     * @return string|null
     */
    public function getMinReadyDate()
    {
        return $this->MinReadyDate;
    }
    /**
     * Set MinReadyDate value
     * @param string $minReadyDate
     * @return \StructType\AvailablePickupDay
     */
    public function setMinReadyDate($minReadyDate = null)
    {
        // validation for constraint: string
        if (!is_null($minReadyDate) && !is_string($minReadyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minReadyDate, true), gettype($minReadyDate)), __LINE__);
        }
        $this->MinReadyDate = $minReadyDate;
        return $this;
    }
    /**
     * Get MaxPickupDate value
     * @return string|null
     */
    public function getMaxPickupDate()
    {
        return $this->MaxPickupDate;
    }
    /**
     * Set MaxPickupDate value
     * @param string $maxPickupDate
     * @return \StructType\AvailablePickupDay
     */
    public function setMaxPickupDate($maxPickupDate = null)
    {
        // validation for constraint: string
        if (!is_null($maxPickupDate) && !is_string($maxPickupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxPickupDate, true), gettype($maxPickupDate)), __LINE__);
        }
        $this->MaxPickupDate = $maxPickupDate;
        return $this;
    }
}
