<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Put ServiceType
 * @subpackage Services
 */
class Put extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PutCustomerPackCanceled
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PutCustomerPackCanceled $parameters
     * @return \StructType\PutCustomerPackCanceledResponse|bool
     */
    public function PutCustomerPackCanceled(\StructType\PutCustomerPackCanceled $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PutCustomerPackCanceled($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PutCustomerShippingCodeCanceled
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PutCustomerShippingCodeCanceled $parameters
     * @return \StructType\PutCustomerShippingCodeCanceledResponse|bool
     */
    public function PutCustomerShippingCodeCanceled(\StructType\PutCustomerShippingCodeCanceled $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PutCustomerShippingCodeCanceled($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PutCustomerPack
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PutCustomerPack $parameters
     * @return \StructType\PutCustomerPackResponse|bool
     */
    public function PutCustomerPack(\StructType\PutCustomerPack $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PutCustomerPack($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PutCustomerPackCanceledResponse|\StructType\PutCustomerPackResponse|\StructType\PutCustomerShippingCodeCanceledResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
