<?php

namespace karali\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Servis ServiceType
 * @subpackage Services
 * @version 1.1
 * @date 2024/03/05
 */
class Servis extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named servisIstegi
     * Meta information extracted from the WSDL
     * - documentation: Oda ve Borsa servisleri genel transport noktasi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \karali\StructType\ServisIstegi $parameters
     * @return \karali\StructType\ServisIstegiResponse|bool
     */
    public function servisIstegi(\karali\StructType\ServisIstegi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->servisIstegi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \karali\StructType\ServisIstegiResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
