<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://odaborsaws.tobb.org.tr/OdaBorsa?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://odaborsaws.tobb.org.tr/OdaBorsa?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \karali\ClassMap::get(),
);
/**
 * Samples for Heart ServiceType
 */
$heart = new \karali\ServiceType\Heart($options);
/**
 * Sample call for heartBeat operation/method
 */
if ($heart->heartBeat(new \karali\StructType\HeartBeat()) !== false) {
    print_r($heart->getResult());
} else {
    print_r($heart->getLastError());
}
/**
 * Samples for Servis ServiceType
 */
$servis = new \karali\ServiceType\Servis($options);
/**
 * Sample call for servisIstegi operation/method
 */
if ($servis->servisIstegi(new \karali\StructType\ServisIstegi()) !== false) {
    print_r($servis->getResult());
} else {
    print_r($servis->getLastError());
}
