<?php

namespace karali\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Heart ServiceType
 * @subpackage Services
 * @version 1.0
 * @date 2024/03/05
 */
class Heart extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named heartBeat
     * Meta information extracted from the WSDL
     * - documentation: servis HeartBeat metodu
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \karali\StructType\HeartBeat $parameters
     * @return \karali\StructType\HeartBeatResponse|bool
     */
    public function heartBeat(\karali\StructType\HeartBeat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->heartBeat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \karali\StructType\HeartBeatResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
