<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://commsy.hamburg.schulcommsy.de/soap_wsdl.php/',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://commsy.hamburg.schulcommsy.de/soap_wsdl.php/',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getGuestSession operation/method
 */
if ($get->getGuestSession($portal_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getActiveRoomList operation/method
 */
if ($get->getActiveRoomList($session_id, $portal_id, $count) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getActiveRoomListForUser operation/method
 */
if ($get->getActiveRoomListForUser($session_id, $portal_id, $count) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCountRooms operation/method
 */
if ($get->getCountRooms($session_id, $portal_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCountUser operation/method
 */
if ($get->getCountUser($session_id, $portal_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMaterialList operation/method
 */
if ($get->getMaterialList($session_id, $context_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPrivateRoomMaterialList operation/method
 */
if ($get->getPrivateRoomMaterialList($session_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSectionListFromMaterial operation/method
 */
if ($get->getSectionListFromMaterial($session_id, $material_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFileListFromMaterial operation/method
 */
if ($get->getFileListFromMaterial($session_id, $material_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFileListFromItem operation/method
 */
if ($get->getFileListFromItem($session_id, $item_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFileItem operation/method
 */
if ($get->getFileItem($session_id, $file_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBuzzwordList operation/method
 */
if ($get->getBuzzwordList($session_id, $context_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLabelList operation/method
 */
if ($get->getLabelList($session_id, $context_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getGroupList operation/method
 */
if ($get->getGroupList($session_id, $context_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTopicList operation/method
 */
if ($get->getTopicList($session_id, $context_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getUserInfo operation/method
 */
if ($get->getUserInfo($session_id, $context_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRSSUrl operation/method
 */
if ($get->getRSSUrl($session_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRoomList operation/method
 */
if ($get->getRoomList($session_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPortalRoomConfiguration operation/method
 */
if ($get->getPortalRoomConfiguration($session_id, $portal_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRoomDetails operation/method
 */
if ($get->getRoomDetails($session_id, $context_id, $room_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAuthenticationForWiki operation/method
 */
if ($get->getAuthenticationForWiki($session_id, $context_id, $user_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAGBFromRoom operation/method
 */
if ($get->getAGBFromRoom($context_id, $language) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getStatistics operation/method
 */
if ($get->getStatistics($session_id, $start_date, $end_date) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPortalRoomList operation/method
 */
if ($get->getPortalRoomList($session_id, $portal_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPortalRoomListByCountAndSearch operation/method
 */
if ($get->getPortalRoomListByCountAndSearch($session_id, $start, $count, $search, $timeLimit, $roomTypeLimit, $order) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getUserInformation operation/method
 */
if ($get->getUserInformation($session_id, $context_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPortalConfig operation/method
 */
if ($get->getPortalConfig($portal_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAuthSources operation/method
 */
if ($get->getAuthSources($session_id, $portal_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBarInformation operation/method
 */
if ($get->getBarInformation($session_id, $portal_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getContextToU operation/method
 */
if ($get->getContextToU($session_id, $portal_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPortalList operation/method
 */
if ($get->getPortalList() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAnnouncementsInRange operation/method
 */
if ($get->getAnnouncementsInRange($session_id, $context_id, $valid_timestamp) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDatesList operation/method
 */
if ($get->getDatesList($session_id, $context_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDatesInRange operation/method
 */
if ($get->getDatesInRange($session_id, $context_id, $start_timestamp, $end_timestamp) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDateDetails operation/method
 */
if ($get->getDateDetails($session_id, $context_id, $item_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMaterialsList operation/method
 */
if ($get->getMaterialsList($session_id, $context_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMaterialDetails operation/method
 */
if ($get->getMaterialDetails($session_id, $context_id, $item_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDiscussionList operation/method
 */
if ($get->getDiscussionList($session_id, $context_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDiscussionDetails operation/method
 */
if ($get->getDiscussionDetails($session_id, $context_id, $item_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getUserList operation/method
 */
if ($get->getUserList($session_id, $context_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRoomReadCounter operation/method
 */
if ($get->getRoomReadCounter($session_id, $context_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getModerationUserList operation/method
 */
if ($get->getModerationUserList($session_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSessionIdFromConnectionKey operation/method
 */
if ($get->getSessionIdFromConnectionKey($session_id, $portal_id, $user_key, $server_key) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRoomListAsJson operation/method
 */
if ($get->getRoomListAsJson($session_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPortalListAsJson operation/method
 */
if ($get->getPortalListAsJson() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getOwnConnectionKey operation/method
 */
if ($get->getOwnConnectionKey($session_id) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for createUser operation/method
 */
if ($create->createUser($session_id, $portal_id, $firstname, $lastname, $mail, $user_id, $user_pwd, $agb, $send_email) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createMembershipBySession operation/method
 */
if ($create->createMembershipBySession($session_id, $context_id, $agb) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Authenticate ServiceType
 */
$authenticate = new \ServiceType\Authenticate($options);
/**
 * Sample call for authenticate operation/method
 */
if ($authenticate->authenticate($user_id, $password, $portal_id, $auth_source_id) !== false) {
    print_r($authenticate->getResult());
} else {
    print_r($authenticate->getLastError());
}
/**
 * Sample call for authenticateWithLogin operation/method
 */
if ($authenticate->authenticateWithLogin($user_id, $password, $portal_id, $auth_source_id) !== false) {
    print_r($authenticate->getResult());
} else {
    print_r($authenticate->getLastError());
}
/**
 * Sample call for authenticateViaSession operation/method
 */
if ($authenticate->authenticateViaSession($session_id) !== false) {
    print_r($authenticate->getResult());
} else {
    print_r($authenticate->getLastError());
}
/**
 * Sample call for authenticateForApp operation/method
 */
if ($authenticate->authenticateForApp($user_id, $password, $portal_id, $auth_source_id) !== false) {
    print_r($authenticate->getResult());
} else {
    print_r($authenticate->getLastError());
}
/**
 * Samples for IMS ServiceType
 */
$iMS = new \ServiceType\IMS($options);
/**
 * Sample call for IMS operation/method
 */
if ($iMS->IMS($session_id, $ims_xml) !== false) {
    print_r($iMS->getResult());
} else {
    print_r($iMS->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for deleteFileItem operation/method
 */
if ($delete->deleteFileItem($session_id, $file_id) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteRoom operation/method
 */
if ($delete->deleteRoom($session_id, $portal_id, $room_id) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteDate operation/method
 */
if ($delete->deleteDate($session_id, $context_id, $item_id) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteMaterial operation/method
 */
if ($delete->deleteMaterial($session_id, $context_id, $item_id) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteSection operation/method
 */
if ($delete->deleteSection($session_id, $context_id, $item_id) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteDiscussion operation/method
 */
if ($delete->deleteDiscussion($session_id, $context_id, $item_id) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteDiscussionArticle operation/method
 */
if ($delete->deleteDiscussionArticle($session_id, $context_id, $item_id) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteConnection operation/method
 */
if ($delete->deleteConnection($session_id, $tab_id) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for addPrivateRoomMaterialList operation/method
 */
if ($add->addPrivateRoomMaterialList($session_id, $material_list_xml) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addFileForMaterial operation/method
 */
if ($add->addFileForMaterial($session_id, $material_id, $file_item_xml) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addMaterialLimit operation/method
 */
if ($add->addMaterialLimit($key, $value, $session_id) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Link ServiceType
 */
$link = new \ServiceType\Link($options);
/**
 * Sample call for linkFileToMaterial operation/method
 */
if ($link->linkFileToMaterial($session_id, $material_id, $file_id) !== false) {
    print_r($link->getResult());
} else {
    print_r($link->getLastError());
}
/**
 * Samples for Tou ServiceType
 */
$tou = new \ServiceType\Tou($options);
/**
 * Sample call for touAccepted operation/method
 */
if ($tou->touAccepted($session_id, $portal_id) !== false) {
    print_r($tou->getResult());
} else {
    print_r($tou->getLastError());
}
/**
 * Samples for Save ServiceType
 */
$save = new \ServiceType\Save($options);
/**
 * Sample call for saveRoom operation/method
 */
if ($save->saveRoom($session_id, $context_id, $title, $id, $type, $template, $language, $intervals, $assignments, $description) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for savePosForItem operation/method
 */
if ($save->savePosForItem($session_id, $item_id, $x, $y) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for savePosForLink operation/method
 */
if ($save->savePosForLink($session_id, $item_id, $label_id, $x, $y) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for saveDate operation/method
 */
if ($save->saveDate($session_id, $context_id, $item_id, $title, $place, $description, $startingDate, $startingTime, $endingDate, $endingTime, $uploadFiles, $deleteFiles) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for saveMaterial operation/method
 */
if ($save->saveMaterial($session_id, $context_id, $item_id, $title, $description, $uploadFiles, $deleteFiles) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for saveSection operation/method
 */
if ($save->saveSection($session_id, $context_id, $item_id, $title, $description, $number, $uploadFiles, $deleteFiles, $material_item_id) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for saveDiscussionArticle operation/method
 */
if ($save->saveDiscussionArticle($session_id, $context_id, $item_id, $title, $description, $uploadFiles, $deleteFiles, $discussion_item_id, $answerTo) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for saveDiscussionWithInitialArticle operation/method
 */
if ($save->saveDiscussionWithInitialArticle($session_id, $context_id, $item_id, $title, $item_id_article, $title_article, $description_article, $uploadFiles, $deleteFiles) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for saveDiscussion operation/method
 */
if ($save->saveDiscussion($session_id, $context_id, $item_id, $title) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for saveUser operation/method
 */
if ($save->saveUser($session_id, $context_id, $item_id, $name, $firstname, $email, $phone1, $phone2) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for saveExternalConnectionKey operation/method
 */
if ($save->saveExternalConnectionKey($session_id, $user_key) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Samples for Archive ServiceType
 */
$archive = new \ServiceType\Archive($options);
/**
 * Sample call for archiveRoom operation/method
 */
if ($archive->archiveRoom($session_id, $portal_id, $room_id) !== false) {
    print_r($archive->getResult());
} else {
    print_r($archive->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
/**
 * Sample call for sendContactMail operation/method
 */
if ($send->sendContactMail($session_id, $context_id, $message) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendIdForget operation/method
 */
if ($send->sendIdForget($session_id, $portal_id, $email) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendPwForget operation/method
 */
if ($send->sendPwForget($session_id, $portal_id, $identification) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Refresh ServiceType
 */
$refresh = new \ServiceType\Refresh($options);
/**
 * Sample call for refreshSession operation/method
 */
if ($refresh->refreshSession($session_id) !== false) {
    print_r($refresh->getResult());
} else {
    print_r($refresh->getLastError());
}
/**
 * Samples for Logout ServiceType
 */
$logout = new \ServiceType\Logout($options);
/**
 * Sample call for logout operation/method
 */
if ($logout->logout($session_id) !== false) {
    print_r($logout->getResult());
} else {
    print_r($logout->getLastError());
}
/**
 * Samples for Wordpress ServiceType
 */
$wordpress = new \ServiceType\Wordpress($options);
/**
 * Sample call for wordpressAuthenticateViaSession operation/method
 */
if ($wordpress->wordpressAuthenticateViaSession($session_id) !== false) {
    print_r($wordpress->getResult());
} else {
    print_r($wordpress->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \ServiceType\Change($options);
/**
 * Sample call for changeUserEmail operation/method
 */
if ($change->changeUserEmail($session_id, $email) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for changeUserEmailAll operation/method
 */
if ($change->changeUserEmailAll($session_id, $email) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for changeUserId operation/method
 */
if ($change->changeUserId($session_id, $user_id) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for changeUserName operation/method
 */
if ($change->changeUserName($session_id, $firstname, $lastname) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
/**
 * Sample call for setUserExternalId operation/method
 */
if ($set->setUserExternalId($session_id, $external_id) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setPortalConnectionInfo operation/method
 */
if ($set->setPortalConnectionInfo($session_id, $server_key, $portal_id, $tab_id, $user_key) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for updateLastlogin operation/method
 */
if ($update->updateLastlogin($session_id, $tool, $room_id) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Register ServiceType
 */
$register = new \ServiceType\Register($options);
/**
 * Sample call for registerUser operation/method
 */
if ($register->registerUser($session_id, $portal_id, $firstname, $lastname, $email, $identification, $password, $tou) !== false) {
    print_r($register->getResult());
} else {
    print_r($register->getLastError());
}
/**
 * Samples for Upload ServiceType
 */
$upload = new \ServiceType\Upload($options);
/**
 * Sample call for uploadFile operation/method
 */
if ($upload->uploadFile($session_id, $context_id, $file_id, $file_data) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Samples for Activate ServiceType
 */
$activate = new \ServiceType\Activate($options);
/**
 * Sample call for activateUser operation/method
 */
if ($activate->activateUser($session_id, $activate_user_id) !== false) {
    print_r($activate->getResult());
} else {
    print_r($activate->getLastError());
}
