<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Register ServiceType
 * @subpackage Services
 */
class Register extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named registerUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $portal_id
     * @param string $firstname
     * @param string $lastname
     * @param string $email
     * @param string $identification
     * @param string $password
     * @param string $tou
     * @return string|bool
     */
    public function registerUser($session_id, $portal_id, $firstname, $lastname, $email, $identification, $password, $tou)
    {
        try {
            $this->setResult(self::getSoapClient()->registerUser($session_id, $portal_id, $firstname, $lastname, $email, $identification, $password, $tou));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
