<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Link ServiceType
 * @subpackage Services
 */
class Link extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named linkFileToMaterial
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $material_id
     * @param string $file_id
     * @return string|bool
     */
    public function linkFileToMaterial($session_id, $material_id, $file_id)
    {
        try {
            $this->setResult(self::getSoapClient()->linkFileToMaterial($session_id, $material_id, $file_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
