<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Authenticate ServiceType
 * @subpackage Services
 */
class Authenticate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named authenticate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user_id
     * @param string $password
     * @param string $portal_id
     * @param string $auth_source_id
     * @return string|bool
     */
    public function authenticate($user_id, $password, $portal_id, $auth_source_id)
    {
        try {
            $this->setResult(self::getSoapClient()->authenticate($user_id, $password, $portal_id, $auth_source_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named authenticateWithLogin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user_id
     * @param string $password
     * @param string $portal_id
     * @param string $auth_source_id
     * @return string|bool
     */
    public function authenticateWithLogin($user_id, $password, $portal_id, $auth_source_id)
    {
        try {
            $this->setResult(self::getSoapClient()->authenticateWithLogin($user_id, $password, $portal_id, $auth_source_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named authenticateViaSession
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @return string|bool
     */
    public function authenticateViaSession($session_id)
    {
        try {
            $this->setResult(self::getSoapClient()->authenticateViaSession($session_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named authenticateForApp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user_id
     * @param string $password
     * @param string $portal_id
     * @param string $auth_source_id
     * @return string|bool
     */
    public function authenticateForApp($user_id, $password, $portal_id, $auth_source_id)
    {
        try {
            $this->setResult(self::getSoapClient()->authenticateForApp($user_id, $password, $portal_id, $auth_source_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
