<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named addPrivateRoomMaterialList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $material_list_xml
     * @return string|bool
     */
    public function addPrivateRoomMaterialList($session_id, $material_list_xml)
    {
        try {
            $this->setResult(self::getSoapClient()->addPrivateRoomMaterialList($session_id, $material_list_xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addFileForMaterial
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $material_id
     * @param string $file_item_xml
     * @return string|bool
     */
    public function addFileForMaterial($session_id, $material_id, $file_item_xml)
    {
        try {
            $this->setResult(self::getSoapClient()->addFileForMaterial($session_id, $material_id, $file_item_xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMaterialLimit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $key
     * @param string $value
     * @param string $session_id
     * @return boolean|bool
     */
    public function addMaterialLimit($key, $value, $session_id)
    {
        try {
            $this->setResult(self::getSoapClient()->addMaterialLimit($key, $value, $session_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean|string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
