<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save ServiceType
 * @subpackage Services
 */
class Save extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named saveRoom
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @param string $title
     * @param string $id
     * @param string $type
     * @param string $template
     * @param string $language
     * @param string $intervals
     * @param string $assignments
     * @param string $description
     * @return string|bool
     */
    public function saveRoom($session_id, $context_id, $title, $id, $type, $template, $language, $intervals, $assignments, $description)
    {
        try {
            $this->setResult(self::getSoapClient()->saveRoom($session_id, $context_id, $title, $id, $type, $template, $language, $intervals, $assignments, $description));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named savePosForItem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $item_id
     * @param string $x
     * @param string $y
     * @return boolean|bool
     */
    public function savePosForItem($session_id, $item_id, $x, $y)
    {
        try {
            $this->setResult(self::getSoapClient()->savePosForItem($session_id, $item_id, $x, $y));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named savePosForLink
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $item_id
     * @param string $label_id
     * @param string $x
     * @param string $y
     * @return boolean|bool
     */
    public function savePosForLink($session_id, $item_id, $label_id, $x, $y)
    {
        try {
            $this->setResult(self::getSoapClient()->savePosForLink($session_id, $item_id, $label_id, $x, $y));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named saveDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @param string $item_id
     * @param string $title
     * @param string $place
     * @param string $description
     * @param string $startingDate
     * @param string $startingTime
     * @param string $endingDate
     * @param string $endingTime
     * @param string $uploadFiles
     * @param string $deleteFiles
     * @return string|bool
     */
    public function saveDate($session_id, $context_id, $item_id, $title, $place, $description, $startingDate, $startingTime, $endingDate, $endingTime, $uploadFiles, $deleteFiles)
    {
        try {
            $this->setResult(self::getSoapClient()->saveDate($session_id, $context_id, $item_id, $title, $place, $description, $startingDate, $startingTime, $endingDate, $endingTime, $uploadFiles, $deleteFiles));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named saveMaterial
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @param string $item_id
     * @param string $title
     * @param string $description
     * @param string $uploadFiles
     * @param string $deleteFiles
     * @return string|bool
     */
    public function saveMaterial($session_id, $context_id, $item_id, $title, $description, $uploadFiles, $deleteFiles)
    {
        try {
            $this->setResult(self::getSoapClient()->saveMaterial($session_id, $context_id, $item_id, $title, $description, $uploadFiles, $deleteFiles));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named saveSection
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @param string $item_id
     * @param string $title
     * @param string $description
     * @param string $number
     * @param string $uploadFiles
     * @param string $deleteFiles
     * @param string $material_item_id
     * @return string|bool
     */
    public function saveSection($session_id, $context_id, $item_id, $title, $description, $number, $uploadFiles, $deleteFiles, $material_item_id)
    {
        try {
            $this->setResult(self::getSoapClient()->saveSection($session_id, $context_id, $item_id, $title, $description, $number, $uploadFiles, $deleteFiles, $material_item_id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named saveDiscussionArticle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @param string $item_id
     * @param string $title
     * @param string $description
     * @param string $uploadFiles
     * @param string $deleteFiles
     * @param string $discussion_item_id
     * @param string $answerTo
     * @return string|bool
     */
    public function saveDiscussionArticle($session_id, $context_id, $item_id, $title, $description, $uploadFiles, $deleteFiles, $discussion_item_id, $answerTo)
    {
        try {
            $this->setResult(self::getSoapClient()->saveDiscussionArticle($session_id, $context_id, $item_id, $title, $description, $uploadFiles, $deleteFiles, $discussion_item_id, $answerTo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named saveDiscussionWithInitialArticle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @param string $item_id
     * @param string $title
     * @param string $item_id_article
     * @param string $title_article
     * @param string $description_article
     * @param string $uploadFiles
     * @param string $deleteFiles
     * @return string|bool
     */
    public function saveDiscussionWithInitialArticle($session_id, $context_id, $item_id, $title, $item_id_article, $title_article, $description_article, $uploadFiles, $deleteFiles)
    {
        try {
            $this->setResult(self::getSoapClient()->saveDiscussionWithInitialArticle($session_id, $context_id, $item_id, $title, $item_id_article, $title_article, $description_article, $uploadFiles, $deleteFiles));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named saveDiscussion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @param string $item_id
     * @param string $title
     * @return string|bool
     */
    public function saveDiscussion($session_id, $context_id, $item_id, $title)
    {
        try {
            $this->setResult(self::getSoapClient()->saveDiscussion($session_id, $context_id, $item_id, $title));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named saveUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @param string $item_id
     * @param string $name
     * @param string $firstname
     * @param string $email
     * @param string $phone1
     * @param string $phone2
     * @return string|bool
     */
    public function saveUser($session_id, $context_id, $item_id, $name, $firstname, $email, $phone1, $phone2)
    {
        try {
            $this->setResult(self::getSoapClient()->saveUser($session_id, $context_id, $item_id, $name, $firstname, $email, $phone1, $phone2));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named saveExternalConnectionKey
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $user_key
     * @return string|bool
     */
    public function saveExternalConnectionKey($session_id, $user_key)
    {
        try {
            $this->setResult(self::getSoapClient()->saveExternalConnectionKey($session_id, $user_key));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean|string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
