<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named createUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $portal_id
     * @param string $firstname
     * @param string $lastname
     * @param string $mail
     * @param string $user_id
     * @param string $user_pwd
     * @param string $agb
     * @param string $send_email
     * @return string|bool
     */
    public function createUser($session_id, $portal_id, $firstname, $lastname, $mail, $user_id, $user_pwd, $agb, $send_email)
    {
        try {
            $this->setResult(self::getSoapClient()->createUser($session_id, $portal_id, $firstname, $lastname, $mail, $user_id, $user_pwd, $agb, $send_email));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createMembershipBySession
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $session_id
     * @param string $context_id
     * @param string $agb
     * @return boolean|bool
     */
    public function createMembershipBySession($session_id, $context_id, $agb)
    {
        try {
            $this->setResult(self::getSoapClient()->createMembershipBySession($session_id, $context_id, $agb));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean|string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
