<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://annuitiesext.assureweb.co.uk/services/annuitycomparisonquickquoteservice.svc?singlewsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://annuitiesext.assureweb.co.uk/services/annuitycomparisonquickquoteservice.svc?singlewsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Quote ServiceType
 */
$quote = new \ServiceType\Quote($options);
/**
 * Sample call for SubmitAnnuityComparisonQuickQuote operation/method
 */
if ($quote->SubmitAnnuityComparisonQuickQuote(new \StructType\SubmitAnnuityComparisonQuickQuote()) !== false) {
    print_r($quote->getResult());
} else {
    print_r($quote->getLastError());
}
/**
 * Samples for Results ServiceType
 */
$results = new \ServiceType\Results($options);
/**
 * Sample call for RetrieveAnnuityComparisonQuickQuoteResults operation/method
 */
if ($results->RetrieveAnnuityComparisonQuickQuoteResults(new \StructType\RetrieveAnnuityComparisonQuickQuoteResults()) !== false) {
    print_r($results->getResult());
} else {
    print_r($results->getLastError());
}
/**
 * Samples for Report ServiceType
 */
$report = new \ServiceType\Report($options);
/**
 * Sample call for RetrieveAnnuityComparisonQuickQuoteReport operation/method
 */
if ($report->RetrieveAnnuityComparisonQuickQuoteReport(new \StructType\RetrieveAnnuityComparisonQuickQuoteReport()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
