<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Person StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Person
 * @subpackage Structs
 */
class Person extends AbstractStructBase
{
    /**
     * The GeneralHealthIssues
     * @var string
     */
    public $GeneralHealthIssues;
    /**
     * The Smoker
     * @var string
     */
    public $Smoker;
    /**
     * The DateOfBirth
     * @var string
     */
    public $DateOfBirth;
    /**
     * The Forename
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Forename;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * The Postcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Postcode;
    /**
     * The Surname
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Surname;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * Constructor method for Person
     * @uses Person::setGeneralHealthIssues()
     * @uses Person::setSmoker()
     * @uses Person::setDateOfBirth()
     * @uses Person::setForename()
     * @uses Person::setGender()
     * @uses Person::setPostcode()
     * @uses Person::setSurname()
     * @uses Person::setTitle()
     * @param string $generalHealthIssues
     * @param string $smoker
     * @param string $dateOfBirth
     * @param string $forename
     * @param string $gender
     * @param string $postcode
     * @param string $surname
     * @param string $title
     */
    public function __construct($generalHealthIssues = null, $smoker = null, $dateOfBirth = null, $forename = null, $gender = null, $postcode = null, $surname = null, $title = null)
    {
        $this
            ->setGeneralHealthIssues($generalHealthIssues)
            ->setSmoker($smoker)
            ->setDateOfBirth($dateOfBirth)
            ->setForename($forename)
            ->setGender($gender)
            ->setPostcode($postcode)
            ->setSurname($surname)
            ->setTitle($title);
    }
    /**
     * Get GeneralHealthIssues value
     * @return string|null
     */
    public function getGeneralHealthIssues()
    {
        return $this->GeneralHealthIssues;
    }
    /**
     * Set GeneralHealthIssues value
     * @uses \EnumType\YesNoUnknownAnswer_x0020_::valueIsValid()
     * @uses \EnumType\YesNoUnknownAnswer_x0020_::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $generalHealthIssues
     * @return \StructType\Person
     */
    public function setGeneralHealthIssues($generalHealthIssues = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\YesNoUnknownAnswer_x0020_::valueIsValid($generalHealthIssues)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\YesNoUnknownAnswer_x0020_', is_array($generalHealthIssues) ? implode(', ', $generalHealthIssues) : var_export($generalHealthIssues, true), implode(', ', \EnumType\YesNoUnknownAnswer_x0020_::getValidValues())), __LINE__);
        }
        $this->GeneralHealthIssues = $generalHealthIssues;
        return $this;
    }
    /**
     * Get Smoker value
     * @return string|null
     */
    public function getSmoker()
    {
        return $this->Smoker;
    }
    /**
     * Set Smoker value
     * @uses \EnumType\YesNoUnknownAnswer_x0020_::valueIsValid()
     * @uses \EnumType\YesNoUnknownAnswer_x0020_::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $smoker
     * @return \StructType\Person
     */
    public function setSmoker($smoker = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\YesNoUnknownAnswer_x0020_::valueIsValid($smoker)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\YesNoUnknownAnswer_x0020_', is_array($smoker) ? implode(', ', $smoker) : var_export($smoker, true), implode(', ', \EnumType\YesNoUnknownAnswer_x0020_::getValidValues())), __LINE__);
        }
        $this->Smoker = $smoker;
        return $this;
    }
    /**
     * Get DateOfBirth value
     * @return string|null
     */
    public function getDateOfBirth()
    {
        return $this->DateOfBirth;
    }
    /**
     * Set DateOfBirth value
     * @param string $dateOfBirth
     * @return \StructType\Person
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfBirth) && !is_string($dateOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfBirth, true), gettype($dateOfBirth)), __LINE__);
        }
        $this->DateOfBirth = $dateOfBirth;
        return $this;
    }
    /**
     * Get Forename value
     * @return string|null
     */
    public function getForename()
    {
        return $this->Forename;
    }
    /**
     * Set Forename value
     * @param string $forename
     * @return \StructType\Person
     */
    public function setForename($forename = null)
    {
        // validation for constraint: string
        if (!is_null($forename) && !is_string($forename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forename, true), gettype($forename)), __LINE__);
        }
        $this->Forename = $forename;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @uses \EnumType\Gender::valueIsValid()
     * @uses \EnumType\Gender::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \StructType\Person
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Gender::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Gender', is_array($gender) ? implode(', ', $gender) : var_export($gender, true), implode(', ', \EnumType\Gender::getValidValues())), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get Postcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcode()
    {
        return isset($this->Postcode) ? $this->Postcode : null;
    }
    /**
     * Set Postcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcode
     * @return \StructType\Person
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        if (is_null($postcode) || (is_array($postcode) && empty($postcode))) {
            unset($this->Postcode);
        } else {
            $this->Postcode = $postcode;
        }
        return $this;
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \StructType\Person
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get Title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitle()
    {
        return isset($this->Title) ? $this->Title : null;
    }
    /**
     * Set Title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $title
     * @return \StructType\Person
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->Title);
        } else {
            $this->Title = $title;
        }
        return $this;
    }
}
