<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargePercentage StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ChargePercentage
 * @subpackage Structs
 */
class ChargePercentage extends AbstractStructBase
{
    /**
     * The Frequency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Frequency;
    /**
     * The Percentage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Percentage;
    /**
     * The SpecifiedPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SpecifiedPeriod
     */
    public $SpecifiedPeriod;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StartDate;
    /**
     * Constructor method for ChargePercentage
     * @uses ChargePercentage::setFrequency()
     * @uses ChargePercentage::setPercentage()
     * @uses ChargePercentage::setSpecifiedPeriod()
     * @uses ChargePercentage::setStartDate()
     * @param string $frequency
     * @param float $percentage
     * @param \StructType\SpecifiedPeriod $specifiedPeriod
     * @param string $startDate
     */
    public function __construct($frequency = null, $percentage = null, \StructType\SpecifiedPeriod $specifiedPeriod = null, $startDate = null)
    {
        $this
            ->setFrequency($frequency)
            ->setPercentage($percentage)
            ->setSpecifiedPeriod($specifiedPeriod)
            ->setStartDate($startDate);
    }
    /**
     * Get Frequency value
     * @return string|null
     */
    public function getFrequency()
    {
        return $this->Frequency;
    }
    /**
     * Set Frequency value
     * @uses \EnumType\Frequency::valueIsValid()
     * @uses \EnumType\Frequency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $frequency
     * @return \StructType\ChargePercentage
     */
    public function setFrequency($frequency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Frequency::valueIsValid($frequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Frequency', is_array($frequency) ? implode(', ', $frequency) : var_export($frequency, true), implode(', ', \EnumType\Frequency::getValidValues())), __LINE__);
        }
        $this->Frequency = $frequency;
        return $this;
    }
    /**
     * Get Percentage value
     * @return float|null
     */
    public function getPercentage()
    {
        return $this->Percentage;
    }
    /**
     * Set Percentage value
     * @param float $percentage
     * @return \StructType\ChargePercentage
     */
    public function setPercentage($percentage = null)
    {
        // validation for constraint: float
        if (!is_null($percentage) && !(is_float($percentage) || is_numeric($percentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentage, true), gettype($percentage)), __LINE__);
        }
        $this->Percentage = $percentage;
        return $this;
    }
    /**
     * Get SpecifiedPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SpecifiedPeriod|null
     */
    public function getSpecifiedPeriod()
    {
        return isset($this->SpecifiedPeriod) ? $this->SpecifiedPeriod : null;
    }
    /**
     * Set SpecifiedPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SpecifiedPeriod $specifiedPeriod
     * @return \StructType\ChargePercentage
     */
    public function setSpecifiedPeriod(\StructType\SpecifiedPeriod $specifiedPeriod = null)
    {
        if (is_null($specifiedPeriod) || (is_array($specifiedPeriod) && empty($specifiedPeriod))) {
            unset($this->SpecifiedPeriod);
        } else {
            $this->SpecifiedPeriod = $specifiedPeriod;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\ChargePercentage
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
}
