<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnnuityTerm StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AnnuityTerm
 * @subpackage Structs
 */
class AnnuityTerm extends AbstractStructBase
{
    /**
     * The AnnuityTermOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AnnuityTermOptions;
    /**
     * The Term
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MonthYear
     */
    public $Term;
    /**
     * The ToAge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ToAge;
    /**
     * Constructor method for AnnuityTerm
     * @uses AnnuityTerm::setAnnuityTermOptions()
     * @uses AnnuityTerm::setTerm()
     * @uses AnnuityTerm::setToAge()
     * @param string $annuityTermOptions
     * @param \StructType\MonthYear $term
     * @param int $toAge
     */
    public function __construct($annuityTermOptions = null, \StructType\MonthYear $term = null, $toAge = null)
    {
        $this
            ->setAnnuityTermOptions($annuityTermOptions)
            ->setTerm($term)
            ->setToAge($toAge);
    }
    /**
     * Get AnnuityTermOptions value
     * @return string|null
     */
    public function getAnnuityTermOptions()
    {
        return $this->AnnuityTermOptions;
    }
    /**
     * Set AnnuityTermOptions value
     * @uses \EnumType\AnnuityTermOptions::valueIsValid()
     * @uses \EnumType\AnnuityTermOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $annuityTermOptions
     * @return \StructType\AnnuityTerm
     */
    public function setAnnuityTermOptions($annuityTermOptions = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AnnuityTermOptions::valueIsValid($annuityTermOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AnnuityTermOptions', is_array($annuityTermOptions) ? implode(', ', $annuityTermOptions) : var_export($annuityTermOptions, true), implode(', ', \EnumType\AnnuityTermOptions::getValidValues())), __LINE__);
        }
        $this->AnnuityTermOptions = $annuityTermOptions;
        return $this;
    }
    /**
     * Get Term value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MonthYear|null
     */
    public function getTerm()
    {
        return isset($this->Term) ? $this->Term : null;
    }
    /**
     * Set Term value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\MonthYear $term
     * @return \StructType\AnnuityTerm
     */
    public function setTerm(\StructType\MonthYear $term = null)
    {
        if (is_null($term) || (is_array($term) && empty($term))) {
            unset($this->Term);
        } else {
            $this->Term = $term;
        }
        return $this;
    }
    /**
     * Get ToAge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getToAge()
    {
        return isset($this->ToAge) ? $this->ToAge : null;
    }
    /**
     * Set ToAge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $toAge
     * @return \StructType\AnnuityTerm
     */
    public function setToAge($toAge = null)
    {
        // validation for constraint: int
        if (!is_null($toAge) && !(is_int($toAge) || ctype_digit($toAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toAge, true), gettype($toAge)), __LINE__);
        }
        if (is_null($toAge) || (is_array($toAge) && empty($toAge))) {
            unset($this->ToAge);
        } else {
            $this->ToAge = $toAge;
        }
        return $this;
    }
}
