<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for PaymentFrequency EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentFrequency
 * @subpackage Enumerations
 */
class PaymentFrequency extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Monthly'
     * @return string 'Monthly'
     */
    const VALUE_MONTHLY = 'Monthly';
    /**
     * Constant for value 'Quarterly'
     * @return string 'Quarterly'
     */
    const VALUE_QUARTERLY = 'Quarterly';
    /**
     * Constant for value 'HalfYearly'
     * @return string 'HalfYearly'
     */
    const VALUE_HALF_YEARLY = 'HalfYearly';
    /**
     * Constant for value 'Yearly'
     * @return string 'Yearly'
     */
    const VALUE_YEARLY = 'Yearly';
    /**
     * Return allowed values
     * @uses self::VALUE_MONTHLY
     * @uses self::VALUE_QUARTERLY
     * @uses self::VALUE_HALF_YEARLY
     * @uses self::VALUE_YEARLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MONTHLY,
            self::VALUE_QUARTERLY,
            self::VALUE_HALF_YEARLY,
            self::VALUE_YEARLY,
        );
    }
}
