<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MonthYear StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MonthYear
 * @subpackage Structs
 */
class MonthYear extends AbstractStructBase
{
    /**
     * The Month
     * @var int
     */
    public $Month;
    /**
     * The Year
     * @var int
     */
    public $Year;
    /**
     * Constructor method for MonthYear
     * @uses MonthYear::setMonth()
     * @uses MonthYear::setYear()
     * @param int $month
     * @param int $year
     */
    public function __construct($month = null, $year = null)
    {
        $this
            ->setMonth($month)
            ->setYear($year);
    }
    /**
     * Get Month value
     * @return int|null
     */
    public function getMonth()
    {
        return $this->Month;
    }
    /**
     * Set Month value
     * @param int $month
     * @return \StructType\MonthYear
     */
    public function setMonth($month = null)
    {
        // validation for constraint: int
        if (!is_null($month) && !(is_int($month) || ctype_digit($month))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($month, true), gettype($month)), __LINE__);
        }
        $this->Month = $month;
        return $this;
    }
    /**
     * Get Year value
     * @return int|null
     */
    public function getYear()
    {
        return $this->Year;
    }
    /**
     * Set Year value
     * @param int $year
     * @return \StructType\MonthYear
     */
    public function setYear($year = null)
    {
        // validation for constraint: int
        if (!is_null($year) && !(is_int($year) || ctype_digit($year))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($year, true), gettype($year)), __LINE__);
        }
        $this->Year = $year;
        return $this;
    }
}
