<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InitialAdviserCharges StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:InitialAdviserCharges
 * @subpackage Structs
 */
class InitialAdviserCharges extends AbstractStructBase
{
    /**
     * The DeductedFrom
     * @var string
     */
    public $DeductedFrom;
    /**
     * The SingleContribution
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\InitialCharge
     */
    public $SingleContribution;
    /**
     * Constructor method for InitialAdviserCharges
     * @uses InitialAdviserCharges::setDeductedFrom()
     * @uses InitialAdviserCharges::setSingleContribution()
     * @param string $deductedFrom
     * @param \StructType\InitialCharge $singleContribution
     */
    public function __construct($deductedFrom = null, \StructType\InitialCharge $singleContribution = null)
    {
        $this
            ->setDeductedFrom($deductedFrom)
            ->setSingleContribution($singleContribution);
    }
    /**
     * Get DeductedFrom value
     * @return string|null
     */
    public function getDeductedFrom()
    {
        return $this->DeductedFrom;
    }
    /**
     * Set DeductedFrom value
     * @uses \EnumType\AdviserChargeDeductedFrom::valueIsValid()
     * @uses \EnumType\AdviserChargeDeductedFrom::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deductedFrom
     * @return \StructType\InitialAdviserCharges
     */
    public function setDeductedFrom($deductedFrom = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AdviserChargeDeductedFrom::valueIsValid($deductedFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdviserChargeDeductedFrom', is_array($deductedFrom) ? implode(', ', $deductedFrom) : var_export($deductedFrom, true), implode(', ', \EnumType\AdviserChargeDeductedFrom::getValidValues())), __LINE__);
        }
        $this->DeductedFrom = $deductedFrom;
        return $this;
    }
    /**
     * Get SingleContribution value
     * @return \StructType\InitialCharge|null
     */
    public function getSingleContribution()
    {
        return $this->SingleContribution;
    }
    /**
     * Set SingleContribution value
     * @param \StructType\InitialCharge $singleContribution
     * @return \StructType\InitialAdviserCharges
     */
    public function setSingleContribution(\StructType\InitialCharge $singleContribution = null)
    {
        $this->SingleContribution = $singleContribution;
        return $this;
    }
}
