<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FcaPromptData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FcaPromptData
 * @subpackage Structs
 */
class FcaPromptData extends AbstractStructBase
{
    /**
     * The AdditionalPensionBenefits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AdditionalPensionBenefits
     */
    public $AdditionalPensionBenefits;
    /**
     * The ClientQuotationConsentInd
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ClientQuotationConsentInd;
    /**
     * The DiscloseLifestyleOrMedicalInformationInd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DiscloseLifestyleOrMedicalInformationInd;
    /**
     * Constructor method for FcaPromptData
     * @uses FcaPromptData::setAdditionalPensionBenefits()
     * @uses FcaPromptData::setClientQuotationConsentInd()
     * @uses FcaPromptData::setDiscloseLifestyleOrMedicalInformationInd()
     * @param \StructType\AdditionalPensionBenefits $additionalPensionBenefits
     * @param string $clientQuotationConsentInd
     * @param string $discloseLifestyleOrMedicalInformationInd
     */
    public function __construct(\StructType\AdditionalPensionBenefits $additionalPensionBenefits = null, $clientQuotationConsentInd = null, $discloseLifestyleOrMedicalInformationInd = null)
    {
        $this
            ->setAdditionalPensionBenefits($additionalPensionBenefits)
            ->setClientQuotationConsentInd($clientQuotationConsentInd)
            ->setDiscloseLifestyleOrMedicalInformationInd($discloseLifestyleOrMedicalInformationInd);
    }
    /**
     * Get AdditionalPensionBenefits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AdditionalPensionBenefits|null
     */
    public function getAdditionalPensionBenefits()
    {
        return isset($this->AdditionalPensionBenefits) ? $this->AdditionalPensionBenefits : null;
    }
    /**
     * Set AdditionalPensionBenefits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AdditionalPensionBenefits $additionalPensionBenefits
     * @return \StructType\FcaPromptData
     */
    public function setAdditionalPensionBenefits(\StructType\AdditionalPensionBenefits $additionalPensionBenefits = null)
    {
        if (is_null($additionalPensionBenefits) || (is_array($additionalPensionBenefits) && empty($additionalPensionBenefits))) {
            unset($this->AdditionalPensionBenefits);
        } else {
            $this->AdditionalPensionBenefits = $additionalPensionBenefits;
        }
        return $this;
    }
    /**
     * Get ClientQuotationConsentInd value
     * @return string|null
     */
    public function getClientQuotationConsentInd()
    {
        return $this->ClientQuotationConsentInd;
    }
    /**
     * Set ClientQuotationConsentInd value
     * @uses \EnumType\YesNo::valueIsValid()
     * @uses \EnumType\YesNo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clientQuotationConsentInd
     * @return \StructType\FcaPromptData
     */
    public function setClientQuotationConsentInd($clientQuotationConsentInd = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\YesNo::valueIsValid($clientQuotationConsentInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\YesNo', is_array($clientQuotationConsentInd) ? implode(', ', $clientQuotationConsentInd) : var_export($clientQuotationConsentInd, true), implode(', ', \EnumType\YesNo::getValidValues())), __LINE__);
        }
        $this->ClientQuotationConsentInd = $clientQuotationConsentInd;
        return $this;
    }
    /**
     * Get DiscloseLifestyleOrMedicalInformationInd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDiscloseLifestyleOrMedicalInformationInd()
    {
        return isset($this->DiscloseLifestyleOrMedicalInformationInd) ? $this->DiscloseLifestyleOrMedicalInformationInd : null;
    }
    /**
     * Set DiscloseLifestyleOrMedicalInformationInd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\YesNo::valueIsValid()
     * @uses \EnumType\YesNo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $discloseLifestyleOrMedicalInformationInd
     * @return \StructType\FcaPromptData
     */
    public function setDiscloseLifestyleOrMedicalInformationInd($discloseLifestyleOrMedicalInformationInd = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\YesNo::valueIsValid($discloseLifestyleOrMedicalInformationInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\YesNo', is_array($discloseLifestyleOrMedicalInformationInd) ? implode(', ', $discloseLifestyleOrMedicalInformationInd) : var_export($discloseLifestyleOrMedicalInformationInd, true), implode(', ', \EnumType\YesNo::getValidValues())), __LINE__);
        }
        if (is_null($discloseLifestyleOrMedicalInformationInd) || (is_array($discloseLifestyleOrMedicalInformationInd) && empty($discloseLifestyleOrMedicalInformationInd))) {
            unset($this->DiscloseLifestyleOrMedicalInformationInd);
        } else {
            $this->DiscloseLifestyleOrMedicalInformationInd = $discloseLifestyleOrMedicalInformationInd;
        }
        return $this;
    }
}
