<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeAmount StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ChargeAmount
 * @subpackage Structs
 */
class ChargeAmount extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The FixedIndexation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FixedIndexation;
    /**
     * The Frequency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Frequency;
    /**
     * The Indexation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Indexation;
    /**
     * The SpecifiedPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SpecifiedPeriod
     */
    public $SpecifiedPeriod;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StartDate;
    /**
     * Constructor method for ChargeAmount
     * @uses ChargeAmount::setAmount()
     * @uses ChargeAmount::setFixedIndexation()
     * @uses ChargeAmount::setFrequency()
     * @uses ChargeAmount::setIndexation()
     * @uses ChargeAmount::setSpecifiedPeriod()
     * @uses ChargeAmount::setStartDate()
     * @param float $amount
     * @param float $fixedIndexation
     * @param string $frequency
     * @param string $indexation
     * @param \StructType\SpecifiedPeriod $specifiedPeriod
     * @param string $startDate
     */
    public function __construct($amount = null, $fixedIndexation = null, $frequency = null, $indexation = null, \StructType\SpecifiedPeriod $specifiedPeriod = null, $startDate = null)
    {
        $this
            ->setAmount($amount)
            ->setFixedIndexation($fixedIndexation)
            ->setFrequency($frequency)
            ->setIndexation($indexation)
            ->setSpecifiedPeriod($specifiedPeriod)
            ->setStartDate($startDate);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\ChargeAmount
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get FixedIndexation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFixedIndexation()
    {
        return isset($this->FixedIndexation) ? $this->FixedIndexation : null;
    }
    /**
     * Set FixedIndexation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $fixedIndexation
     * @return \StructType\ChargeAmount
     */
    public function setFixedIndexation($fixedIndexation = null)
    {
        // validation for constraint: float
        if (!is_null($fixedIndexation) && !(is_float($fixedIndexation) || is_numeric($fixedIndexation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fixedIndexation, true), gettype($fixedIndexation)), __LINE__);
        }
        if (is_null($fixedIndexation) || (is_array($fixedIndexation) && empty($fixedIndexation))) {
            unset($this->FixedIndexation);
        } else {
            $this->FixedIndexation = $fixedIndexation;
        }
        return $this;
    }
    /**
     * Get Frequency value
     * @return string|null
     */
    public function getFrequency()
    {
        return $this->Frequency;
    }
    /**
     * Set Frequency value
     * @uses \EnumType\Frequency::valueIsValid()
     * @uses \EnumType\Frequency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $frequency
     * @return \StructType\ChargeAmount
     */
    public function setFrequency($frequency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Frequency::valueIsValid($frequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Frequency', is_array($frequency) ? implode(', ', $frequency) : var_export($frequency, true), implode(', ', \EnumType\Frequency::getValidValues())), __LINE__);
        }
        $this->Frequency = $frequency;
        return $this;
    }
    /**
     * Get Indexation value
     * @return string|null
     */
    public function getIndexation()
    {
        return $this->Indexation;
    }
    /**
     * Set Indexation value
     * @uses \EnumType\Indexation::valueIsValid()
     * @uses \EnumType\Indexation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $indexation
     * @return \StructType\ChargeAmount
     */
    public function setIndexation($indexation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Indexation::valueIsValid($indexation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Indexation', is_array($indexation) ? implode(', ', $indexation) : var_export($indexation, true), implode(', ', \EnumType\Indexation::getValidValues())), __LINE__);
        }
        $this->Indexation = $indexation;
        return $this;
    }
    /**
     * Get SpecifiedPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SpecifiedPeriod|null
     */
    public function getSpecifiedPeriod()
    {
        return isset($this->SpecifiedPeriod) ? $this->SpecifiedPeriod : null;
    }
    /**
     * Set SpecifiedPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SpecifiedPeriod $specifiedPeriod
     * @return \StructType\ChargeAmount
     */
    public function setSpecifiedPeriod(\StructType\SpecifiedPeriod $specifiedPeriod = null)
    {
        if (is_null($specifiedPeriod) || (is_array($specifiedPeriod) && empty($specifiedPeriod))) {
            unset($this->SpecifiedPeriod);
        } else {
            $this->SpecifiedPeriod = $specifiedPeriod;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\ChargeAmount
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
}
