<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveAnnuityComparisonQuoteResultsRequestMessage
 * StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveAnnuityComparisonQuoteResultsRequestMessage
 * @subpackage Structs
 */
class RetrieveAnnuityComparisonQuoteResultsRequestMessage extends AbstractStructBase
{
    /**
     * The ComparisonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ComparisonId;
    /**
     * The Header
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\MessageHeader
     */
    public $Header;
    /**
     * Constructor method for RetrieveAnnuityComparisonQuoteResultsRequestMessage
     * @uses RetrieveAnnuityComparisonQuoteResultsRequestMessage::setComparisonId()
     * @uses RetrieveAnnuityComparisonQuoteResultsRequestMessage::setHeader()
     * @param string $comparisonId
     * @param \StructType\MessageHeader $header
     */
    public function __construct($comparisonId = null, \StructType\MessageHeader $header = null)
    {
        $this
            ->setComparisonId($comparisonId)
            ->setHeader($header);
    }
    /**
     * Get ComparisonId value
     * @return string|null
     */
    public function getComparisonId()
    {
        return $this->ComparisonId;
    }
    /**
     * Set ComparisonId value
     * @param string $comparisonId
     * @return \StructType\RetrieveAnnuityComparisonQuoteResultsRequestMessage
     */
    public function setComparisonId($comparisonId = null)
    {
        // validation for constraint: string
        if (!is_null($comparisonId) && !is_string($comparisonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comparisonId, true), gettype($comparisonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($comparisonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $comparisonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($comparisonId, true)), __LINE__);
        }
        $this->ComparisonId = $comparisonId;
        return $this;
    }
    /**
     * Get Header value
     * @return \StructType\MessageHeader|null
     */
    public function getHeader()
    {
        return $this->Header;
    }
    /**
     * Set Header value
     * @param \StructType\MessageHeader $header
     * @return \StructType\RetrieveAnnuityComparisonQuoteResultsRequestMessage
     */
    public function setHeader(\StructType\MessageHeader $header = null)
    {
        $this->Header = $header;
        return $this;
    }
}
