<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalPensionBenefits StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AdditionalPensionBenefits
 * @subpackage Structs
 */
class AdditionalPensionBenefits extends AbstractStructBase
{
    /**
     * The GuaranteedAnnualIncomeDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfGuaranteedAnnualIncomeDetail
     */
    public $GuaranteedAnnualIncomeDetails;
    /**
     * The ProtectedTaxFreeCashInd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProtectedTaxFreeCashInd;
    /**
     * Constructor method for AdditionalPensionBenefits
     * @uses AdditionalPensionBenefits::setGuaranteedAnnualIncomeDetails()
     * @uses AdditionalPensionBenefits::setProtectedTaxFreeCashInd()
     * @param \ArrayType\ArrayOfGuaranteedAnnualIncomeDetail $guaranteedAnnualIncomeDetails
     * @param string $protectedTaxFreeCashInd
     */
    public function __construct(\ArrayType\ArrayOfGuaranteedAnnualIncomeDetail $guaranteedAnnualIncomeDetails = null, $protectedTaxFreeCashInd = null)
    {
        $this
            ->setGuaranteedAnnualIncomeDetails($guaranteedAnnualIncomeDetails)
            ->setProtectedTaxFreeCashInd($protectedTaxFreeCashInd);
    }
    /**
     * Get GuaranteedAnnualIncomeDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfGuaranteedAnnualIncomeDetail|null
     */
    public function getGuaranteedAnnualIncomeDetails()
    {
        return isset($this->GuaranteedAnnualIncomeDetails) ? $this->GuaranteedAnnualIncomeDetails : null;
    }
    /**
     * Set GuaranteedAnnualIncomeDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfGuaranteedAnnualIncomeDetail $guaranteedAnnualIncomeDetails
     * @return \StructType\AdditionalPensionBenefits
     */
    public function setGuaranteedAnnualIncomeDetails(\ArrayType\ArrayOfGuaranteedAnnualIncomeDetail $guaranteedAnnualIncomeDetails = null)
    {
        if (is_null($guaranteedAnnualIncomeDetails) || (is_array($guaranteedAnnualIncomeDetails) && empty($guaranteedAnnualIncomeDetails))) {
            unset($this->GuaranteedAnnualIncomeDetails);
        } else {
            $this->GuaranteedAnnualIncomeDetails = $guaranteedAnnualIncomeDetails;
        }
        return $this;
    }
    /**
     * Get ProtectedTaxFreeCashInd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProtectedTaxFreeCashInd()
    {
        return isset($this->ProtectedTaxFreeCashInd) ? $this->ProtectedTaxFreeCashInd : null;
    }
    /**
     * Set ProtectedTaxFreeCashInd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\YesNo::valueIsValid()
     * @uses \EnumType\YesNo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protectedTaxFreeCashInd
     * @return \StructType\AdditionalPensionBenefits
     */
    public function setProtectedTaxFreeCashInd($protectedTaxFreeCashInd = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\YesNo::valueIsValid($protectedTaxFreeCashInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\YesNo', is_array($protectedTaxFreeCashInd) ? implode(', ', $protectedTaxFreeCashInd) : var_export($protectedTaxFreeCashInd, true), implode(', ', \EnumType\YesNo::getValidValues())), __LINE__);
        }
        if (is_null($protectedTaxFreeCashInd) || (is_array($protectedTaxFreeCashInd) && empty($protectedTaxFreeCashInd))) {
            unset($this->ProtectedTaxFreeCashInd);
        } else {
            $this->ProtectedTaxFreeCashInd = $protectedTaxFreeCashInd;
        }
        return $this;
    }
}
