<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionHeaders StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionHeaders
 * @subpackage Structs
 */
class TransactionHeaders extends AbstractStructBase
{
    /**
     * The IllustrationBasis
     * @var string
     */
    public $IllustrationBasis;
    /**
     * The QuoteReferences
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\QuoteReferences
     */
    public $QuoteReferences;
    /**
     * Constructor method for TransactionHeaders
     * @uses TransactionHeaders::setIllustrationBasis()
     * @uses TransactionHeaders::setQuoteReferences()
     * @param string $illustrationBasis
     * @param \StructType\QuoteReferences $quoteReferences
     */
    public function __construct($illustrationBasis = null, \StructType\QuoteReferences $quoteReferences = null)
    {
        $this
            ->setIllustrationBasis($illustrationBasis)
            ->setQuoteReferences($quoteReferences);
    }
    /**
     * Get IllustrationBasis value
     * @return string|null
     */
    public function getIllustrationBasis()
    {
        return $this->IllustrationBasis;
    }
    /**
     * Set IllustrationBasis value
     * @uses \EnumType\IllustrationBasis::valueIsValid()
     * @uses \EnumType\IllustrationBasis::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $illustrationBasis
     * @return \StructType\TransactionHeaders
     */
    public function setIllustrationBasis($illustrationBasis = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IllustrationBasis::valueIsValid($illustrationBasis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IllustrationBasis', is_array($illustrationBasis) ? implode(', ', $illustrationBasis) : var_export($illustrationBasis, true), implode(', ', \EnumType\IllustrationBasis::getValidValues())), __LINE__);
        }
        $this->IllustrationBasis = $illustrationBasis;
        return $this;
    }
    /**
     * Get QuoteReferences value
     * @return \StructType\QuoteReferences|null
     */
    public function getQuoteReferences()
    {
        return $this->QuoteReferences;
    }
    /**
     * Set QuoteReferences value
     * @param \StructType\QuoteReferences $quoteReferences
     * @return \StructType\TransactionHeaders
     */
    public function setQuoteReferences(\StructType\QuoteReferences $quoteReferences = null)
    {
        $this->QuoteReferences = $quoteReferences;
        return $this;
    }
}
