<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnnuityQuoteResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AnnuityQuoteResult
 * @subpackage Structs
 */
class AnnuityQuoteResult extends AbstractStructBase
{
    /**
     * The AnnualAnnuity
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $AnnualAnnuity;
    /**
     * The AssumedBonusRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AssumedBonusRate;
    /**
     * The AvailableOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AvailableOptions
     */
    public $AvailableOptions;
    /**
     * The ConfirmedEnhancedRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfirmedEnhancedRate;
    /**
     * The Contract_x0020_Type
     * @var string
     */
    public $Contract_x0020_Type;
    /**
     * The GuaranteedMaturityValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $GuaranteedMaturityValue;
    /**
     * The MinimumIncomeLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MinimumIncomeLevel;
    /**
     * The ProductDisplayName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ProductDisplayName;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProductId;
    /**
     * The ProductName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductName;
    /**
     * The ProviderDisplayName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ProviderDisplayName;
    /**
     * The ProviderQuoteStatus
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ProviderQuoteStatus
     */
    public $ProviderQuoteStatus;
    /**
     * The ProviderShortName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ProviderShortName;
    /**
     * The QuoteId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $QuoteId;
    /**
     * The Remuneration
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $Remuneration;
    /**
     * The RemunerationText
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RemunerationText;
    /**
     * Constructor method for AnnuityQuoteResult
     * @uses AnnuityQuoteResult::setAnnualAnnuity()
     * @uses AnnuityQuoteResult::setAssumedBonusRate()
     * @uses AnnuityQuoteResult::setAvailableOptions()
     * @uses AnnuityQuoteResult::setConfirmedEnhancedRate()
     * @uses AnnuityQuoteResult::setContract_x0020_Type()
     * @uses AnnuityQuoteResult::setGuaranteedMaturityValue()
     * @uses AnnuityQuoteResult::setMinimumIncomeLevel()
     * @uses AnnuityQuoteResult::setProductDisplayName()
     * @uses AnnuityQuoteResult::setProductId()
     * @uses AnnuityQuoteResult::setProductName()
     * @uses AnnuityQuoteResult::setProviderDisplayName()
     * @uses AnnuityQuoteResult::setProviderQuoteStatus()
     * @uses AnnuityQuoteResult::setProviderShortName()
     * @uses AnnuityQuoteResult::setQuoteId()
     * @uses AnnuityQuoteResult::setRemuneration()
     * @uses AnnuityQuoteResult::setRemunerationText()
     * @param float $annualAnnuity
     * @param float $assumedBonusRate
     * @param \StructType\AvailableOptions $availableOptions
     * @param string $confirmedEnhancedRate
     * @param string $contract_x0020_Type
     * @param float $guaranteedMaturityValue
     * @param float $minimumIncomeLevel
     * @param string $productDisplayName
     * @param int $productId
     * @param string $productName
     * @param string $providerDisplayName
     * @param \StructType\ProviderQuoteStatus $providerQuoteStatus
     * @param string $providerShortName
     * @param string $quoteId
     * @param float $remuneration
     * @param string $remunerationText
     */
    public function __construct($annualAnnuity = null, $assumedBonusRate = null, \StructType\AvailableOptions $availableOptions = null, $confirmedEnhancedRate = null, $contract_x0020_Type = null, $guaranteedMaturityValue = null, $minimumIncomeLevel = null, $productDisplayName = null, $productId = null, $productName = null, $providerDisplayName = null, \StructType\ProviderQuoteStatus $providerQuoteStatus = null, $providerShortName = null, $quoteId = null, $remuneration = null, $remunerationText = null)
    {
        $this
            ->setAnnualAnnuity($annualAnnuity)
            ->setAssumedBonusRate($assumedBonusRate)
            ->setAvailableOptions($availableOptions)
            ->setConfirmedEnhancedRate($confirmedEnhancedRate)
            ->setContract_x0020_Type($contract_x0020_Type)
            ->setGuaranteedMaturityValue($guaranteedMaturityValue)
            ->setMinimumIncomeLevel($minimumIncomeLevel)
            ->setProductDisplayName($productDisplayName)
            ->setProductId($productId)
            ->setProductName($productName)
            ->setProviderDisplayName($providerDisplayName)
            ->setProviderQuoteStatus($providerQuoteStatus)
            ->setProviderShortName($providerShortName)
            ->setQuoteId($quoteId)
            ->setRemuneration($remuneration)
            ->setRemunerationText($remunerationText);
    }
    /**
     * Get AnnualAnnuity value
     * @return float|null
     */
    public function getAnnualAnnuity()
    {
        return $this->AnnualAnnuity;
    }
    /**
     * Set AnnualAnnuity value
     * @param float $annualAnnuity
     * @return \StructType\AnnuityQuoteResult
     */
    public function setAnnualAnnuity($annualAnnuity = null)
    {
        // validation for constraint: float
        if (!is_null($annualAnnuity) && !(is_float($annualAnnuity) || is_numeric($annualAnnuity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($annualAnnuity, true), gettype($annualAnnuity)), __LINE__);
        }
        $this->AnnualAnnuity = $annualAnnuity;
        return $this;
    }
    /**
     * Get AssumedBonusRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAssumedBonusRate()
    {
        return isset($this->AssumedBonusRate) ? $this->AssumedBonusRate : null;
    }
    /**
     * Set AssumedBonusRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $assumedBonusRate
     * @return \StructType\AnnuityQuoteResult
     */
    public function setAssumedBonusRate($assumedBonusRate = null)
    {
        // validation for constraint: float
        if (!is_null($assumedBonusRate) && !(is_float($assumedBonusRate) || is_numeric($assumedBonusRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($assumedBonusRate, true), gettype($assumedBonusRate)), __LINE__);
        }
        if (is_null($assumedBonusRate) || (is_array($assumedBonusRate) && empty($assumedBonusRate))) {
            unset($this->AssumedBonusRate);
        } else {
            $this->AssumedBonusRate = $assumedBonusRate;
        }
        return $this;
    }
    /**
     * Get AvailableOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AvailableOptions|null
     */
    public function getAvailableOptions()
    {
        return isset($this->AvailableOptions) ? $this->AvailableOptions : null;
    }
    /**
     * Set AvailableOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AvailableOptions $availableOptions
     * @return \StructType\AnnuityQuoteResult
     */
    public function setAvailableOptions(\StructType\AvailableOptions $availableOptions = null)
    {
        if (is_null($availableOptions) || (is_array($availableOptions) && empty($availableOptions))) {
            unset($this->AvailableOptions);
        } else {
            $this->AvailableOptions = $availableOptions;
        }
        return $this;
    }
    /**
     * Get ConfirmedEnhancedRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfirmedEnhancedRate()
    {
        return isset($this->ConfirmedEnhancedRate) ? $this->ConfirmedEnhancedRate : null;
    }
    /**
     * Set ConfirmedEnhancedRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ConfirmedEnhancedRateIndicator::valueIsValid()
     * @uses \EnumType\ConfirmedEnhancedRateIndicator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $confirmedEnhancedRate
     * @return \StructType\AnnuityQuoteResult
     */
    public function setConfirmedEnhancedRate($confirmedEnhancedRate = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ConfirmedEnhancedRateIndicator::valueIsValid($confirmedEnhancedRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ConfirmedEnhancedRateIndicator', is_array($confirmedEnhancedRate) ? implode(', ', $confirmedEnhancedRate) : var_export($confirmedEnhancedRate, true), implode(', ', \EnumType\ConfirmedEnhancedRateIndicator::getValidValues())), __LINE__);
        }
        if (is_null($confirmedEnhancedRate) || (is_array($confirmedEnhancedRate) && empty($confirmedEnhancedRate))) {
            unset($this->ConfirmedEnhancedRate);
        } else {
            $this->ConfirmedEnhancedRate = $confirmedEnhancedRate;
        }
        return $this;
    }
    /**
     * Get Contract_x0020_Type value
     * @return string|null
     */
    public function getContract_x0020_Type()
    {
        return $this->Contract_x0020_Type;
    }
    /**
     * Set Contract_x0020_Type value
     * @uses \EnumType\QuoteInvestmentType::valueIsValid()
     * @uses \EnumType\QuoteInvestmentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contract_x0020_Type
     * @return \StructType\AnnuityQuoteResult
     */
    public function setContract_x0020_Type($contract_x0020_Type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\QuoteInvestmentType::valueIsValid($contract_x0020_Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\QuoteInvestmentType', is_array($contract_x0020_Type) ? implode(', ', $contract_x0020_Type) : var_export($contract_x0020_Type, true), implode(', ', \EnumType\QuoteInvestmentType::getValidValues())), __LINE__);
        }
        $this->Contract_x0020_Type = $contract_x0020_Type;
        return $this;
    }
    /**
     * Get GuaranteedMaturityValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getGuaranteedMaturityValue()
    {
        return isset($this->GuaranteedMaturityValue) ? $this->GuaranteedMaturityValue : null;
    }
    /**
     * Set GuaranteedMaturityValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $guaranteedMaturityValue
     * @return \StructType\AnnuityQuoteResult
     */
    public function setGuaranteedMaturityValue($guaranteedMaturityValue = null)
    {
        // validation for constraint: float
        if (!is_null($guaranteedMaturityValue) && !(is_float($guaranteedMaturityValue) || is_numeric($guaranteedMaturityValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($guaranteedMaturityValue, true), gettype($guaranteedMaturityValue)), __LINE__);
        }
        if (is_null($guaranteedMaturityValue) || (is_array($guaranteedMaturityValue) && empty($guaranteedMaturityValue))) {
            unset($this->GuaranteedMaturityValue);
        } else {
            $this->GuaranteedMaturityValue = $guaranteedMaturityValue;
        }
        return $this;
    }
    /**
     * Get MinimumIncomeLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMinimumIncomeLevel()
    {
        return isset($this->MinimumIncomeLevel) ? $this->MinimumIncomeLevel : null;
    }
    /**
     * Set MinimumIncomeLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $minimumIncomeLevel
     * @return \StructType\AnnuityQuoteResult
     */
    public function setMinimumIncomeLevel($minimumIncomeLevel = null)
    {
        // validation for constraint: float
        if (!is_null($minimumIncomeLevel) && !(is_float($minimumIncomeLevel) || is_numeric($minimumIncomeLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimumIncomeLevel, true), gettype($minimumIncomeLevel)), __LINE__);
        }
        if (is_null($minimumIncomeLevel) || (is_array($minimumIncomeLevel) && empty($minimumIncomeLevel))) {
            unset($this->MinimumIncomeLevel);
        } else {
            $this->MinimumIncomeLevel = $minimumIncomeLevel;
        }
        return $this;
    }
    /**
     * Get ProductDisplayName value
     * @return string|null
     */
    public function getProductDisplayName()
    {
        return $this->ProductDisplayName;
    }
    /**
     * Set ProductDisplayName value
     * @param string $productDisplayName
     * @return \StructType\AnnuityQuoteResult
     */
    public function setProductDisplayName($productDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($productDisplayName) && !is_string($productDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productDisplayName, true), gettype($productDisplayName)), __LINE__);
        }
        $this->ProductDisplayName = $productDisplayName;
        return $this;
    }
    /**
     * Get ProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProductId()
    {
        return isset($this->ProductId) ? $this->ProductId : null;
    }
    /**
     * Set ProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $productId
     * @return \StructType\AnnuityQuoteResult
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        if (is_null($productId) || (is_array($productId) && empty($productId))) {
            unset($this->ProductId);
        } else {
            $this->ProductId = $productId;
        }
        return $this;
    }
    /**
     * Get ProductName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductName()
    {
        return isset($this->ProductName) ? $this->ProductName : null;
    }
    /**
     * Set ProductName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productName
     * @return \StructType\AnnuityQuoteResult
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        if (is_null($productName) || (is_array($productName) && empty($productName))) {
            unset($this->ProductName);
        } else {
            $this->ProductName = $productName;
        }
        return $this;
    }
    /**
     * Get ProviderDisplayName value
     * @return string|null
     */
    public function getProviderDisplayName()
    {
        return $this->ProviderDisplayName;
    }
    /**
     * Set ProviderDisplayName value
     * @param string $providerDisplayName
     * @return \StructType\AnnuityQuoteResult
     */
    public function setProviderDisplayName($providerDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($providerDisplayName) && !is_string($providerDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerDisplayName, true), gettype($providerDisplayName)), __LINE__);
        }
        $this->ProviderDisplayName = $providerDisplayName;
        return $this;
    }
    /**
     * Get ProviderQuoteStatus value
     * @return \StructType\ProviderQuoteStatus|null
     */
    public function getProviderQuoteStatus()
    {
        return $this->ProviderQuoteStatus;
    }
    /**
     * Set ProviderQuoteStatus value
     * @param \StructType\ProviderQuoteStatus $providerQuoteStatus
     * @return \StructType\AnnuityQuoteResult
     */
    public function setProviderQuoteStatus(\StructType\ProviderQuoteStatus $providerQuoteStatus = null)
    {
        $this->ProviderQuoteStatus = $providerQuoteStatus;
        return $this;
    }
    /**
     * Get ProviderShortName value
     * @return string|null
     */
    public function getProviderShortName()
    {
        return $this->ProviderShortName;
    }
    /**
     * Set ProviderShortName value
     * @param string $providerShortName
     * @return \StructType\AnnuityQuoteResult
     */
    public function setProviderShortName($providerShortName = null)
    {
        // validation for constraint: string
        if (!is_null($providerShortName) && !is_string($providerShortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerShortName, true), gettype($providerShortName)), __LINE__);
        }
        $this->ProviderShortName = $providerShortName;
        return $this;
    }
    /**
     * Get QuoteId value
     * @return string|null
     */
    public function getQuoteId()
    {
        return $this->QuoteId;
    }
    /**
     * Set QuoteId value
     * @param string $quoteId
     * @return \StructType\AnnuityQuoteResult
     */
    public function setQuoteId($quoteId = null)
    {
        // validation for constraint: string
        if (!is_null($quoteId) && !is_string($quoteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quoteId, true), gettype($quoteId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($quoteId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $quoteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($quoteId, true)), __LINE__);
        }
        $this->QuoteId = $quoteId;
        return $this;
    }
    /**
     * Get Remuneration value
     * @return float|null
     */
    public function getRemuneration()
    {
        return $this->Remuneration;
    }
    /**
     * Set Remuneration value
     * @param float $remuneration
     * @return \StructType\AnnuityQuoteResult
     */
    public function setRemuneration($remuneration = null)
    {
        // validation for constraint: float
        if (!is_null($remuneration) && !(is_float($remuneration) || is_numeric($remuneration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($remuneration, true), gettype($remuneration)), __LINE__);
        }
        $this->Remuneration = $remuneration;
        return $this;
    }
    /**
     * Get RemunerationText value
     * @return string|null
     */
    public function getRemunerationText()
    {
        return $this->RemunerationText;
    }
    /**
     * Set RemunerationText value
     * @param string $remunerationText
     * @return \StructType\AnnuityQuoteResult
     */
    public function setRemunerationText($remunerationText = null)
    {
        // validation for constraint: string
        if (!is_null($remunerationText) && !is_string($remunerationText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remunerationText, true), gettype($remunerationText)), __LINE__);
        }
        $this->RemunerationText = $remunerationText;
        return $this;
    }
}
