<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicyBasis StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PolicyBasis
 * @subpackage Structs
 */
class PolicyBasis extends AbstractStructBase
{
    /**
     * The AnnuityTerm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AnnuityTerm
     */
    public $AnnuityTerm;
    /**
     * The ContractType
     * @var string
     */
    public $ContractType;
    /**
     * The ConventionalContractOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ConventionalContractOptions
     */
    public $ConventionalContractOptions;
    /**
     * The DependantPercentage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DependantPercentage;
    /**
     * The GuaranteedPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GuaranteedPeriod;
    /**
     * The GuaranteedPeriodYears
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GuaranteedPeriodYears;
    /**
     * The LivesAssured
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\LivesAssured
     */
    public $LivesAssured;
    /**
     * The LivesAssuredBasis
     * @var string
     */
    public $LivesAssuredBasis;
    /**
     * The PaymentFrequency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentFrequency;
    /**
     * The PaymentTimingCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentTimingCode;
    /**
     * The PurchaseMoneyAfterTaxFreeCashTaken
     * @var int
     */
    public $PurchaseMoneyAfterTaxFreeCashTaken;
    /**
     * The WithProfitsContractOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WithProfitsContractOptions
     */
    public $WithProfitsContractOptions;
    /**
     * Constructor method for PolicyBasis
     * @uses PolicyBasis::setAnnuityTerm()
     * @uses PolicyBasis::setContractType()
     * @uses PolicyBasis::setConventionalContractOptions()
     * @uses PolicyBasis::setDependantPercentage()
     * @uses PolicyBasis::setGuaranteedPeriod()
     * @uses PolicyBasis::setGuaranteedPeriodYears()
     * @uses PolicyBasis::setLivesAssured()
     * @uses PolicyBasis::setLivesAssuredBasis()
     * @uses PolicyBasis::setPaymentFrequency()
     * @uses PolicyBasis::setPaymentTimingCode()
     * @uses PolicyBasis::setPurchaseMoneyAfterTaxFreeCashTaken()
     * @uses PolicyBasis::setWithProfitsContractOptions()
     * @param \StructType\AnnuityTerm $annuityTerm
     * @param string $contractType
     * @param \StructType\ConventionalContractOptions $conventionalContractOptions
     * @param string $dependantPercentage
     * @param string $guaranteedPeriod
     * @param int $guaranteedPeriodYears
     * @param \StructType\LivesAssured $livesAssured
     * @param string $livesAssuredBasis
     * @param string $paymentFrequency
     * @param string $paymentTimingCode
     * @param int $purchaseMoneyAfterTaxFreeCashTaken
     * @param \StructType\WithProfitsContractOptions $withProfitsContractOptions
     */
    public function __construct(\StructType\AnnuityTerm $annuityTerm = null, $contractType = null, \StructType\ConventionalContractOptions $conventionalContractOptions = null, $dependantPercentage = null, $guaranteedPeriod = null, $guaranteedPeriodYears = null, \StructType\LivesAssured $livesAssured = null, $livesAssuredBasis = null, $paymentFrequency = null, $paymentTimingCode = null, $purchaseMoneyAfterTaxFreeCashTaken = null, \StructType\WithProfitsContractOptions $withProfitsContractOptions = null)
    {
        $this
            ->setAnnuityTerm($annuityTerm)
            ->setContractType($contractType)
            ->setConventionalContractOptions($conventionalContractOptions)
            ->setDependantPercentage($dependantPercentage)
            ->setGuaranteedPeriod($guaranteedPeriod)
            ->setGuaranteedPeriodYears($guaranteedPeriodYears)
            ->setLivesAssured($livesAssured)
            ->setLivesAssuredBasis($livesAssuredBasis)
            ->setPaymentFrequency($paymentFrequency)
            ->setPaymentTimingCode($paymentTimingCode)
            ->setPurchaseMoneyAfterTaxFreeCashTaken($purchaseMoneyAfterTaxFreeCashTaken)
            ->setWithProfitsContractOptions($withProfitsContractOptions);
    }
    /**
     * Get AnnuityTerm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AnnuityTerm|null
     */
    public function getAnnuityTerm()
    {
        return isset($this->AnnuityTerm) ? $this->AnnuityTerm : null;
    }
    /**
     * Set AnnuityTerm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AnnuityTerm $annuityTerm
     * @return \StructType\PolicyBasis
     */
    public function setAnnuityTerm(\StructType\AnnuityTerm $annuityTerm = null)
    {
        if (is_null($annuityTerm) || (is_array($annuityTerm) && empty($annuityTerm))) {
            unset($this->AnnuityTerm);
        } else {
            $this->AnnuityTerm = $annuityTerm;
        }
        return $this;
    }
    /**
     * Get ContractType value
     * @return string|null
     */
    public function getContractType()
    {
        return $this->ContractType;
    }
    /**
     * Set ContractType value
     * @uses \EnumType\ContractType::valueIsValid()
     * @uses \EnumType\ContractType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contractType
     * @return \StructType\PolicyBasis
     */
    public function setContractType($contractType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ContractType::valueIsValid($contractType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ContractType', is_array($contractType) ? implode(', ', $contractType) : var_export($contractType, true), implode(', ', \EnumType\ContractType::getValidValues())), __LINE__);
        }
        $this->ContractType = $contractType;
        return $this;
    }
    /**
     * Get ConventionalContractOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ConventionalContractOptions|null
     */
    public function getConventionalContractOptions()
    {
        return isset($this->ConventionalContractOptions) ? $this->ConventionalContractOptions : null;
    }
    /**
     * Set ConventionalContractOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ConventionalContractOptions $conventionalContractOptions
     * @return \StructType\PolicyBasis
     */
    public function setConventionalContractOptions(\StructType\ConventionalContractOptions $conventionalContractOptions = null)
    {
        if (is_null($conventionalContractOptions) || (is_array($conventionalContractOptions) && empty($conventionalContractOptions))) {
            unset($this->ConventionalContractOptions);
        } else {
            $this->ConventionalContractOptions = $conventionalContractOptions;
        }
        return $this;
    }
    /**
     * Get DependantPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDependantPercentage()
    {
        return isset($this->DependantPercentage) ? $this->DependantPercentage : null;
    }
    /**
     * Set DependantPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\DependantPercentage::valueIsValid()
     * @uses \EnumType\DependantPercentage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dependantPercentage
     * @return \StructType\PolicyBasis
     */
    public function setDependantPercentage($dependantPercentage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DependantPercentage::valueIsValid($dependantPercentage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DependantPercentage', is_array($dependantPercentage) ? implode(', ', $dependantPercentage) : var_export($dependantPercentage, true), implode(', ', \EnumType\DependantPercentage::getValidValues())), __LINE__);
        }
        if (is_null($dependantPercentage) || (is_array($dependantPercentage) && empty($dependantPercentage))) {
            unset($this->DependantPercentage);
        } else {
            $this->DependantPercentage = $dependantPercentage;
        }
        return $this;
    }
    /**
     * Get GuaranteedPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuaranteedPeriod()
    {
        return isset($this->GuaranteedPeriod) ? $this->GuaranteedPeriod : null;
    }
    /**
     * Set GuaranteedPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\GuaranteedPeriod::valueIsValid()
     * @uses \EnumType\GuaranteedPeriod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $guaranteedPeriod
     * @return \StructType\PolicyBasis
     */
    public function setGuaranteedPeriod($guaranteedPeriod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GuaranteedPeriod::valueIsValid($guaranteedPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GuaranteedPeriod', is_array($guaranteedPeriod) ? implode(', ', $guaranteedPeriod) : var_export($guaranteedPeriod, true), implode(', ', \EnumType\GuaranteedPeriod::getValidValues())), __LINE__);
        }
        if (is_null($guaranteedPeriod) || (is_array($guaranteedPeriod) && empty($guaranteedPeriod))) {
            unset($this->GuaranteedPeriod);
        } else {
            $this->GuaranteedPeriod = $guaranteedPeriod;
        }
        return $this;
    }
    /**
     * Get GuaranteedPeriodYears value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGuaranteedPeriodYears()
    {
        return isset($this->GuaranteedPeriodYears) ? $this->GuaranteedPeriodYears : null;
    }
    /**
     * Set GuaranteedPeriodYears value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $guaranteedPeriodYears
     * @return \StructType\PolicyBasis
     */
    public function setGuaranteedPeriodYears($guaranteedPeriodYears = null)
    {
        // validation for constraint: int
        if (!is_null($guaranteedPeriodYears) && !(is_int($guaranteedPeriodYears) || ctype_digit($guaranteedPeriodYears))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($guaranteedPeriodYears, true), gettype($guaranteedPeriodYears)), __LINE__);
        }
        if (is_null($guaranteedPeriodYears) || (is_array($guaranteedPeriodYears) && empty($guaranteedPeriodYears))) {
            unset($this->GuaranteedPeriodYears);
        } else {
            $this->GuaranteedPeriodYears = $guaranteedPeriodYears;
        }
        return $this;
    }
    /**
     * Get LivesAssured value
     * @return \StructType\LivesAssured|null
     */
    public function getLivesAssured()
    {
        return $this->LivesAssured;
    }
    /**
     * Set LivesAssured value
     * @param \StructType\LivesAssured $livesAssured
     * @return \StructType\PolicyBasis
     */
    public function setLivesAssured(\StructType\LivesAssured $livesAssured = null)
    {
        $this->LivesAssured = $livesAssured;
        return $this;
    }
    /**
     * Get LivesAssuredBasis value
     * @return string|null
     */
    public function getLivesAssuredBasis()
    {
        return $this->LivesAssuredBasis;
    }
    /**
     * Set LivesAssuredBasis value
     * @uses \EnumType\LivesAssuredBasis::valueIsValid()
     * @uses \EnumType\LivesAssuredBasis::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $livesAssuredBasis
     * @return \StructType\PolicyBasis
     */
    public function setLivesAssuredBasis($livesAssuredBasis = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LivesAssuredBasis::valueIsValid($livesAssuredBasis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LivesAssuredBasis', is_array($livesAssuredBasis) ? implode(', ', $livesAssuredBasis) : var_export($livesAssuredBasis, true), implode(', ', \EnumType\LivesAssuredBasis::getValidValues())), __LINE__);
        }
        $this->LivesAssuredBasis = $livesAssuredBasis;
        return $this;
    }
    /**
     * Get PaymentFrequency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentFrequency()
    {
        return isset($this->PaymentFrequency) ? $this->PaymentFrequency : null;
    }
    /**
     * Set PaymentFrequency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\PaymentFrequency::valueIsValid()
     * @uses \EnumType\PaymentFrequency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentFrequency
     * @return \StructType\PolicyBasis
     */
    public function setPaymentFrequency($paymentFrequency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentFrequency::valueIsValid($paymentFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PaymentFrequency', is_array($paymentFrequency) ? implode(', ', $paymentFrequency) : var_export($paymentFrequency, true), implode(', ', \EnumType\PaymentFrequency::getValidValues())), __LINE__);
        }
        if (is_null($paymentFrequency) || (is_array($paymentFrequency) && empty($paymentFrequency))) {
            unset($this->PaymentFrequency);
        } else {
            $this->PaymentFrequency = $paymentFrequency;
        }
        return $this;
    }
    /**
     * Get PaymentTimingCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTimingCode()
    {
        return isset($this->PaymentTimingCode) ? $this->PaymentTimingCode : null;
    }
    /**
     * Set PaymentTimingCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\PaymentTimingCode::valueIsValid()
     * @uses \EnumType\PaymentTimingCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentTimingCode
     * @return \StructType\PolicyBasis
     */
    public function setPaymentTimingCode($paymentTimingCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentTimingCode::valueIsValid($paymentTimingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PaymentTimingCode', is_array($paymentTimingCode) ? implode(', ', $paymentTimingCode) : var_export($paymentTimingCode, true), implode(', ', \EnumType\PaymentTimingCode::getValidValues())), __LINE__);
        }
        if (is_null($paymentTimingCode) || (is_array($paymentTimingCode) && empty($paymentTimingCode))) {
            unset($this->PaymentTimingCode);
        } else {
            $this->PaymentTimingCode = $paymentTimingCode;
        }
        return $this;
    }
    /**
     * Get PurchaseMoneyAfterTaxFreeCashTaken value
     * @return int|null
     */
    public function getPurchaseMoneyAfterTaxFreeCashTaken()
    {
        return $this->PurchaseMoneyAfterTaxFreeCashTaken;
    }
    /**
     * Set PurchaseMoneyAfterTaxFreeCashTaken value
     * @param int $purchaseMoneyAfterTaxFreeCashTaken
     * @return \StructType\PolicyBasis
     */
    public function setPurchaseMoneyAfterTaxFreeCashTaken($purchaseMoneyAfterTaxFreeCashTaken = null)
    {
        // validation for constraint: int
        if (!is_null($purchaseMoneyAfterTaxFreeCashTaken) && !(is_int($purchaseMoneyAfterTaxFreeCashTaken) || ctype_digit($purchaseMoneyAfterTaxFreeCashTaken))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($purchaseMoneyAfterTaxFreeCashTaken, true), gettype($purchaseMoneyAfterTaxFreeCashTaken)), __LINE__);
        }
        $this->PurchaseMoneyAfterTaxFreeCashTaken = $purchaseMoneyAfterTaxFreeCashTaken;
        return $this;
    }
    /**
     * Get WithProfitsContractOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WithProfitsContractOptions|null
     */
    public function getWithProfitsContractOptions()
    {
        return isset($this->WithProfitsContractOptions) ? $this->WithProfitsContractOptions : null;
    }
    /**
     * Set WithProfitsContractOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WithProfitsContractOptions $withProfitsContractOptions
     * @return \StructType\PolicyBasis
     */
    public function setWithProfitsContractOptions(\StructType\WithProfitsContractOptions $withProfitsContractOptions = null)
    {
        if (is_null($withProfitsContractOptions) || (is_array($withProfitsContractOptions) && empty($withProfitsContractOptions))) {
            unset($this->WithProfitsContractOptions);
        } else {
            $this->WithProfitsContractOptions = $withProfitsContractOptions;
        }
        return $this;
    }
}
