<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Results ServiceType
 * @subpackage Services
 */
class Results extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * RetrieveAnnuityComparisonQuickQuoteResults
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveAnnuityComparisonQuickQuoteResults $parameters
     * @return \StructType\RetrieveAnnuityComparisonQuickQuoteResultsResponse|bool
     */
    public function RetrieveAnnuityComparisonQuickQuoteResults(\StructType\RetrieveAnnuityComparisonQuickQuoteResults $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveAnnuityComparisonQuickQuoteResults($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RetrieveAnnuityComparisonQuickQuoteResultsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
