<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnavailableProduct StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UnavailableProduct
 * @subpackage Structs
 */
class UnavailableProduct extends AbstractStructBase
{
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $ProductId;
    /**
     * The ProductName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ProductName;
    /**
     * The ProductUnavailableReason
     * @var string
     */
    public $ProductUnavailableReason;
    /**
     * The ProviderName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ProviderName;
    /**
     * The ReasonDescriptions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $ReasonDescriptions;
    /**
     * Constructor method for UnavailableProduct
     * @uses UnavailableProduct::setProductId()
     * @uses UnavailableProduct::setProductName()
     * @uses UnavailableProduct::setProductUnavailableReason()
     * @uses UnavailableProduct::setProviderName()
     * @uses UnavailableProduct::setReasonDescriptions()
     * @param int $productId
     * @param string $productName
     * @param string $productUnavailableReason
     * @param string $providerName
     * @param \ArrayType\ArrayOfstring $reasonDescriptions
     */
    public function __construct($productId = null, $productName = null, $productUnavailableReason = null, $providerName = null, \ArrayType\ArrayOfstring $reasonDescriptions = null)
    {
        $this
            ->setProductId($productId)
            ->setProductName($productName)
            ->setProductUnavailableReason($productUnavailableReason)
            ->setProviderName($providerName)
            ->setReasonDescriptions($reasonDescriptions);
    }
    /**
     * Get ProductId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param int $productId
     * @return \StructType\UnavailableProduct
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \StructType\UnavailableProduct
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get ProductUnavailableReason value
     * @return string|null
     */
    public function getProductUnavailableReason()
    {
        return $this->ProductUnavailableReason;
    }
    /**
     * Set ProductUnavailableReason value
     * @uses \EnumType\ProductUnavailableReason::valueIsValid()
     * @uses \EnumType\ProductUnavailableReason::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productUnavailableReason
     * @return \StructType\UnavailableProduct
     */
    public function setProductUnavailableReason($productUnavailableReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductUnavailableReason::valueIsValid($productUnavailableReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProductUnavailableReason', is_array($productUnavailableReason) ? implode(', ', $productUnavailableReason) : var_export($productUnavailableReason, true), implode(', ', \EnumType\ProductUnavailableReason::getValidValues())), __LINE__);
        }
        $this->ProductUnavailableReason = $productUnavailableReason;
        return $this;
    }
    /**
     * Get ProviderName value
     * @return string|null
     */
    public function getProviderName()
    {
        return $this->ProviderName;
    }
    /**
     * Set ProviderName value
     * @param string $providerName
     * @return \StructType\UnavailableProduct
     */
    public function setProviderName($providerName = null)
    {
        // validation for constraint: string
        if (!is_null($providerName) && !is_string($providerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerName, true), gettype($providerName)), __LINE__);
        }
        $this->ProviderName = $providerName;
        return $this;
    }
    /**
     * Get ReasonDescriptions value
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getReasonDescriptions()
    {
        return $this->ReasonDescriptions;
    }
    /**
     * Set ReasonDescriptions value
     * @param \ArrayType\ArrayOfstring $reasonDescriptions
     * @return \StructType\UnavailableProduct
     */
    public function setReasonDescriptions(\ArrayType\ArrayOfstring $reasonDescriptions = null)
    {
        $this->ReasonDescriptions = $reasonDescriptions;
        return $this;
    }
}
