<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Remuneration StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Remuneration
 * @subpackage Structs
 */
class Remuneration extends AbstractStructBase
{
    /**
     * The AdviserCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AdviserCharges
     */
    public $AdviserCharges;
    /**
     * The BasisOfSale
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\BasisOfSale
     */
    public $BasisOfSale;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Commission
     */
    public $Commission;
    /**
     * Constructor method for Remuneration
     * @uses Remuneration::setAdviserCharges()
     * @uses Remuneration::setBasisOfSale()
     * @uses Remuneration::setCommission()
     * @param \StructType\AdviserCharges $adviserCharges
     * @param \StructType\BasisOfSale $basisOfSale
     * @param \StructType\Commission $commission
     */
    public function __construct(\StructType\AdviserCharges $adviserCharges = null, \StructType\BasisOfSale $basisOfSale = null, \StructType\Commission $commission = null)
    {
        $this
            ->setAdviserCharges($adviserCharges)
            ->setBasisOfSale($basisOfSale)
            ->setCommission($commission);
    }
    /**
     * Get AdviserCharges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AdviserCharges|null
     */
    public function getAdviserCharges()
    {
        return isset($this->AdviserCharges) ? $this->AdviserCharges : null;
    }
    /**
     * Set AdviserCharges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AdviserCharges $adviserCharges
     * @return \StructType\Remuneration
     */
    public function setAdviserCharges(\StructType\AdviserCharges $adviserCharges = null)
    {
        if (is_null($adviserCharges) || (is_array($adviserCharges) && empty($adviserCharges))) {
            unset($this->AdviserCharges);
        } else {
            $this->AdviserCharges = $adviserCharges;
        }
        return $this;
    }
    /**
     * Get BasisOfSale value
     * @return \StructType\BasisOfSale|null
     */
    public function getBasisOfSale()
    {
        return $this->BasisOfSale;
    }
    /**
     * Set BasisOfSale value
     * @param \StructType\BasisOfSale $basisOfSale
     * @return \StructType\Remuneration
     */
    public function setBasisOfSale(\StructType\BasisOfSale $basisOfSale = null)
    {
        $this->BasisOfSale = $basisOfSale;
        return $this;
    }
    /**
     * Get Commission value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Commission|null
     */
    public function getCommission()
    {
        return isset($this->Commission) ? $this->Commission : null;
    }
    /**
     * Set Commission value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Commission $commission
     * @return \StructType\Remuneration
     */
    public function setCommission(\StructType\Commission $commission = null)
    {
        if (is_null($commission) || (is_array($commission) && empty($commission))) {
            unset($this->Commission);
        } else {
            $this->Commission = $commission;
        }
        return $this;
    }
}
