<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LivesAssured StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LivesAssured
 * @subpackage Structs
 */
class LivesAssured extends AbstractStructBase
{
    /**
     * The FirstLife
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Person
     */
    public $FirstLife;
    /**
     * The SecondLife
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Person
     */
    public $SecondLife;
    /**
     * Constructor method for LivesAssured
     * @uses LivesAssured::setFirstLife()
     * @uses LivesAssured::setSecondLife()
     * @param \StructType\Person $firstLife
     * @param \StructType\Person $secondLife
     */
    public function __construct(\StructType\Person $firstLife = null, \StructType\Person $secondLife = null)
    {
        $this
            ->setFirstLife($firstLife)
            ->setSecondLife($secondLife);
    }
    /**
     * Get FirstLife value
     * @return \StructType\Person|null
     */
    public function getFirstLife()
    {
        return $this->FirstLife;
    }
    /**
     * Set FirstLife value
     * @param \StructType\Person $firstLife
     * @return \StructType\LivesAssured
     */
    public function setFirstLife(\StructType\Person $firstLife = null)
    {
        $this->FirstLife = $firstLife;
        return $this;
    }
    /**
     * Get SecondLife value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Person|null
     */
    public function getSecondLife()
    {
        return isset($this->SecondLife) ? $this->SecondLife : null;
    }
    /**
     * Set SecondLife value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Person $secondLife
     * @return \StructType\LivesAssured
     */
    public function setSecondLife(\StructType\Person $secondLife = null)
    {
        if (is_null($secondLife) || (is_array($secondLife) && empty($secondLife))) {
            unset($this->SecondLife);
        } else {
            $this->SecondLife = $secondLife;
        }
        return $this;
    }
}
